// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> A value indicating whether Zone Redundant HA and Geo-backup is supported in this region. "Enabled" means zone redundant HA and geo-backup is supported. "Disabled" stands for zone redundant HA and geo-backup is not supported. </summary>
    public readonly partial struct PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported : IEquatable<PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported Enabled { get; } = new PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported(EnabledValue);
        /// <summary> Disabled. </summary>
        public static PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported Disabled { get; } = new PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported(DisabledValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported left, PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported left, PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported(string value) => new PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServerZoneRedundantHaAndGeoBackupSupported other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
