// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Storage edition capability. </summary>
    public partial class PostgreSqlFlexibleServerStorageEditionCapability : PostgreSqlBaseCapability
    {
        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerStorageEditionCapability"/>. </summary>
        internal PostgreSqlFlexibleServerStorageEditionCapability()
        {
            SupportedStorageCapabilities = new ChangeTrackingList<PostgreSqlFlexibleServerStorageCapability>();
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerStorageEditionCapability"/>. </summary>
        /// <param name="capabilityStatus"> The status of the capability. </param>
        /// <param name="reason"> The reason for the capability not being available. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="name"> Storage edition name. </param>
        /// <param name="defaultStorageSizeMb"> Default storage size in MB for storage edition. </param>
        /// <param name="supportedStorageCapabilities"> Flexible server supported storage range in MB. </param>
        internal PostgreSqlFlexibleServerStorageEditionCapability(PostgreSqlFlexbileServerCapabilityStatus? capabilityStatus, string reason, IDictionary<string, BinaryData> serializedAdditionalRawData, string name, long? defaultStorageSizeMb, IReadOnlyList<PostgreSqlFlexibleServerStorageCapability> supportedStorageCapabilities) : base(capabilityStatus, reason, serializedAdditionalRawData)
        {
            Name = name;
            DefaultStorageSizeMb = defaultStorageSizeMb;
            SupportedStorageCapabilities = supportedStorageCapabilities;
        }

        /// <summary> Storage edition name. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> Default storage size in MB for storage edition. </summary>
        [WirePath("defaultStorageSizeMb")]
        public long? DefaultStorageSizeMb { get; }
        /// <summary> Flexible server supported storage range in MB. </summary>
        [WirePath("supportedStorageMb")]
        public IReadOnlyList<PostgreSqlFlexibleServerStorageCapability> SupportedStorageCapabilities { get; }
    }
}
