// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    public partial class PostgreSqlFlexibleServerStorageCapability : IUtf8JsonSerializable, IJsonModel<PostgreSqlFlexibleServerStorageCapability>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PostgreSqlFlexibleServerStorageCapability>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PostgreSqlFlexibleServerStorageCapability>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlFlexibleServerStorageCapability>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PostgreSqlFlexibleServerStorageCapability)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(SupportedIops))
            {
                writer.WritePropertyName("supportedIops"u8);
                writer.WriteNumberValue(SupportedIops.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SupportedMaximumIops))
            {
                writer.WritePropertyName("supportedMaximumIops"u8);
                writer.WriteNumberValue(SupportedMaximumIops.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(StorageSizeInMB))
            {
                writer.WritePropertyName("storageSizeMb"u8);
                writer.WriteNumberValue(StorageSizeInMB.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MaximumStorageSizeMb))
            {
                writer.WritePropertyName("maximumStorageSizeMb"u8);
                writer.WriteNumberValue(MaximumStorageSizeMb.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SupportedThroughput))
            {
                writer.WritePropertyName("supportedThroughput"u8);
                writer.WriteNumberValue(SupportedThroughput.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SupportedMaximumThroughput))
            {
                writer.WritePropertyName("supportedMaximumThroughput"u8);
                writer.WriteNumberValue(SupportedMaximumThroughput.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(DefaultIopsTier))
            {
                writer.WritePropertyName("defaultIopsTier"u8);
                writer.WriteStringValue(DefaultIopsTier);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SupportedIopsTiers))
            {
                writer.WritePropertyName("supportedIopsTiers"u8);
                writer.WriteStartArray();
                foreach (var item in SupportedIopsTiers)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
        }

        PostgreSqlFlexibleServerStorageCapability IJsonModel<PostgreSqlFlexibleServerStorageCapability>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlFlexibleServerStorageCapability>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PostgreSqlFlexibleServerStorageCapability)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePostgreSqlFlexibleServerStorageCapability(document.RootElement, options);
        }

        internal static PostgreSqlFlexibleServerStorageCapability DeserializePostgreSqlFlexibleServerStorageCapability(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long? supportedIops = default;
            int? supportedMaximumIops = default;
            long? storageSizeMb = default;
            long? maximumStorageSizeMb = default;
            int? supportedThroughput = default;
            int? supportedMaximumThroughput = default;
            string defaultIopsTier = default;
            IReadOnlyList<PostgreSqlFlexibleServerStorageTierCapability> supportedIopsTiers = default;
            PostgreSqlFlexbileServerCapabilityStatus? status = default;
            string reason = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("supportedIops"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    supportedIops = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("supportedMaximumIops"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    supportedMaximumIops = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("storageSizeMb"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    storageSizeMb = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("maximumStorageSizeMb"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maximumStorageSizeMb = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("supportedThroughput"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    supportedThroughput = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("supportedMaximumThroughput"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    supportedMaximumThroughput = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("defaultIopsTier"u8))
                {
                    defaultIopsTier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("supportedIopsTiers"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<PostgreSqlFlexibleServerStorageTierCapability> array = new List<PostgreSqlFlexibleServerStorageTierCapability>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(PostgreSqlFlexibleServerStorageTierCapability.DeserializePostgreSqlFlexibleServerStorageTierCapability(item, options));
                    }
                    supportedIopsTiers = array;
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    status = property.Value.GetString().ToPostgreSqlFlexbileServerCapabilityStatus();
                    continue;
                }
                if (property.NameEquals("reason"u8))
                {
                    reason = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PostgreSqlFlexibleServerStorageCapability(
                status,
                reason,
                serializedAdditionalRawData,
                supportedIops,
                supportedMaximumIops,
                storageSizeMb,
                maximumStorageSizeMb,
                supportedThroughput,
                supportedMaximumThroughput,
                defaultIopsTier,
                supportedIopsTiers ?? new ChangeTrackingList<PostgreSqlFlexibleServerStorageTierCapability>());
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SupportedIops), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  supportedIops: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SupportedIops))
                {
                    builder.Append("  supportedIops: ");
                    builder.AppendLine($"'{SupportedIops.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SupportedMaximumIops), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  supportedMaximumIops: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SupportedMaximumIops))
                {
                    builder.Append("  supportedMaximumIops: ");
                    builder.AppendLine($"{SupportedMaximumIops.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StorageSizeInMB), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  storageSizeMb: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StorageSizeInMB))
                {
                    builder.Append("  storageSizeMb: ");
                    builder.AppendLine($"'{StorageSizeInMB.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaximumStorageSizeMb), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  maximumStorageSizeMb: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MaximumStorageSizeMb))
                {
                    builder.Append("  maximumStorageSizeMb: ");
                    builder.AppendLine($"'{MaximumStorageSizeMb.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SupportedThroughput), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  supportedThroughput: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SupportedThroughput))
                {
                    builder.Append("  supportedThroughput: ");
                    builder.AppendLine($"{SupportedThroughput.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SupportedMaximumThroughput), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  supportedMaximumThroughput: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SupportedMaximumThroughput))
                {
                    builder.Append("  supportedMaximumThroughput: ");
                    builder.AppendLine($"{SupportedMaximumThroughput.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DefaultIopsTier), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  defaultIopsTier: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DefaultIopsTier))
                {
                    builder.Append("  defaultIopsTier: ");
                    if (DefaultIopsTier.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DefaultIopsTier}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DefaultIopsTier}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SupportedIopsTiers), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  supportedIopsTiers: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SupportedIopsTiers))
                {
                    if (SupportedIopsTiers.Any())
                    {
                        builder.Append("  supportedIopsTiers: ");
                        builder.AppendLine("[");
                        foreach (var item in SupportedIopsTiers)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  supportedIopsTiers: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CapabilityStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  status: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CapabilityStatus))
                {
                    builder.Append("  status: ");
                    builder.AppendLine($"'{CapabilityStatus.Value.ToSerialString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Reason), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  reason: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Reason))
                {
                    builder.Append("  reason: ");
                    if (Reason.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Reason}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Reason}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<PostgreSqlFlexibleServerStorageCapability>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlFlexibleServerStorageCapability>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(PostgreSqlFlexibleServerStorageCapability)} does not support writing '{options.Format}' format.");
            }
        }

        PostgreSqlFlexibleServerStorageCapability IPersistableModel<PostgreSqlFlexibleServerStorageCapability>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlFlexibleServerStorageCapability>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePostgreSqlFlexibleServerStorageCapability(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PostgreSqlFlexibleServerStorageCapability)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PostgreSqlFlexibleServerStorageCapability>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
