// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Storage properties of a server. </summary>
    public partial class PostgreSqlFlexibleServerStorage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerStorage"/>. </summary>
        public PostgreSqlFlexibleServerStorage()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerStorage"/>. </summary>
        /// <param name="storageSizeInGB"> Max storage allowed for a server. </param>
        /// <param name="autoGrow"> Flag to enable / disable Storage Auto grow for flexible server. </param>
        /// <param name="tier"> Name of storage tier for IOPS. </param>
        /// <param name="iops"> Storage tier IOPS quantity. This property is required to be set for storage Type PremiumV2_LRS. </param>
        /// <param name="throughput"> Storage throughput for the server. This is required to be set for storage Type PremiumV2_LRS. </param>
        /// <param name="storageType"> Storage type for the server. Allowed values are Premium_LRS and PremiumV2_LRS, and default is Premium_LRS if not specified. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PostgreSqlFlexibleServerStorage(int? storageSizeInGB, StorageAutoGrow? autoGrow, PostgreSqlManagedDiskPerformanceTier? tier, int? iops, int? throughput, PostgreSqlFlexibleServersStorageType? storageType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StorageSizeInGB = storageSizeInGB;
            AutoGrow = autoGrow;
            Tier = tier;
            Iops = iops;
            Throughput = throughput;
            StorageType = storageType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Max storage allowed for a server. </summary>
        [WirePath("storageSizeGB")]
        public int? StorageSizeInGB { get; set; }
        /// <summary> Flag to enable / disable Storage Auto grow for flexible server. </summary>
        [WirePath("autoGrow")]
        public StorageAutoGrow? AutoGrow { get; set; }
        /// <summary> Name of storage tier for IOPS. </summary>
        [WirePath("tier")]
        public PostgreSqlManagedDiskPerformanceTier? Tier { get; set; }
        /// <summary> Storage tier IOPS quantity. This property is required to be set for storage Type PremiumV2_LRS. </summary>
        [WirePath("iops")]
        public int? Iops { get; set; }
        /// <summary> Storage throughput for the server. This is required to be set for storage Type PremiumV2_LRS. </summary>
        [WirePath("throughput")]
        public int? Throughput { get; set; }
        /// <summary> Storage type for the server. Allowed values are Premium_LRS and PremiumV2_LRS, and default is Premium_LRS if not specified. </summary>
        [WirePath("type")]
        public PostgreSqlFlexibleServersStorageType? StorageType { get; set; }
    }
}
