// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Server version capabilities. </summary>
    public partial class PostgreSqlFlexibleServerServerVersionCapability : PostgreSqlBaseCapability
    {
        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerServerVersionCapability"/>. </summary>
        internal PostgreSqlFlexibleServerServerVersionCapability()
        {
            SupportedVersionsToUpgrade = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerServerVersionCapability"/>. </summary>
        /// <param name="capabilityStatus"> The status of the capability. </param>
        /// <param name="reason"> The reason for the capability not being available. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="name"> Server version. </param>
        /// <param name="supportedVersionsToUpgrade"> Supported servers versions to upgrade. </param>
        internal PostgreSqlFlexibleServerServerVersionCapability(PostgreSqlFlexbileServerCapabilityStatus? capabilityStatus, string reason, IDictionary<string, BinaryData> serializedAdditionalRawData, string name, IReadOnlyList<string> supportedVersionsToUpgrade) : base(capabilityStatus, reason, serializedAdditionalRawData)
        {
            Name = name;
            SupportedVersionsToUpgrade = supportedVersionsToUpgrade;
        }

        /// <summary> Server version. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> Supported servers versions to upgrade. </summary>
        [WirePath("supportedVersionsToUpgrade")]
        public IReadOnlyList<string> SupportedVersionsToUpgrade { get; }
    }
}
