// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Used to indicate role of the server in replication set. </summary>
    public readonly partial struct PostgreSqlFlexibleServerReplicationRole : IEquatable<PostgreSqlFlexibleServerReplicationRole>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerReplicationRole"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServerReplicationRole(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string PrimaryValue = "Primary";
        private const string AsyncReplicaValue = "AsyncReplica";
        private const string GeoAsyncReplicaValue = "GeoAsyncReplica";

        /// <summary> None. </summary>
        public static PostgreSqlFlexibleServerReplicationRole None { get; } = new PostgreSqlFlexibleServerReplicationRole(NoneValue);
        /// <summary> Primary. </summary>
        public static PostgreSqlFlexibleServerReplicationRole Primary { get; } = new PostgreSqlFlexibleServerReplicationRole(PrimaryValue);
        /// <summary> AsyncReplica. </summary>
        public static PostgreSqlFlexibleServerReplicationRole AsyncReplica { get; } = new PostgreSqlFlexibleServerReplicationRole(AsyncReplicaValue);
        /// <summary> GeoAsyncReplica. </summary>
        public static PostgreSqlFlexibleServerReplicationRole GeoAsyncReplica { get; } = new PostgreSqlFlexibleServerReplicationRole(GeoAsyncReplicaValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerReplicationRole"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServerReplicationRole left, PostgreSqlFlexibleServerReplicationRole right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerReplicationRole"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServerReplicationRole left, PostgreSqlFlexibleServerReplicationRole right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServerReplicationRole"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServerReplicationRole(string value) => new PostgreSqlFlexibleServerReplicationRole(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServerReplicationRole other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServerReplicationRole other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
