// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> The principal type used to represent the type of Active Directory Administrator. </summary>
    public readonly partial struct PostgreSqlFlexibleServerPrincipalType : IEquatable<PostgreSqlFlexibleServerPrincipalType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerPrincipalType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServerPrincipalType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string UserValue = "User";
        private const string GroupValue = "Group";
        private const string ServicePrincipalValue = "ServicePrincipal";

        /// <summary> Unknown. </summary>
        public static PostgreSqlFlexibleServerPrincipalType Unknown { get; } = new PostgreSqlFlexibleServerPrincipalType(UnknownValue);
        /// <summary> User. </summary>
        public static PostgreSqlFlexibleServerPrincipalType User { get; } = new PostgreSqlFlexibleServerPrincipalType(UserValue);
        /// <summary> Group. </summary>
        public static PostgreSqlFlexibleServerPrincipalType Group { get; } = new PostgreSqlFlexibleServerPrincipalType(GroupValue);
        /// <summary> ServicePrincipal. </summary>
        public static PostgreSqlFlexibleServerPrincipalType ServicePrincipal { get; } = new PostgreSqlFlexibleServerPrincipalType(ServicePrincipalValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerPrincipalType"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServerPrincipalType left, PostgreSqlFlexibleServerPrincipalType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerPrincipalType"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServerPrincipalType left, PostgreSqlFlexibleServerPrincipalType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServerPrincipalType"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServerPrincipalType(string value) => new PostgreSqlFlexibleServerPrincipalType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServerPrincipalType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServerPrincipalType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
