// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> A value indicating whether online resize is supported in this region for the given subscription. "Enabled" means storage online resize is supported. "Disabled" means storage online resize is not supported. </summary>
    public readonly partial struct PostgreSqlFlexibleServerOnlineResizeSupported : IEquatable<PostgreSqlFlexibleServerOnlineResizeSupported>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerOnlineResizeSupported"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServerOnlineResizeSupported(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static PostgreSqlFlexibleServerOnlineResizeSupported Enabled { get; } = new PostgreSqlFlexibleServerOnlineResizeSupported(EnabledValue);
        /// <summary> Disabled. </summary>
        public static PostgreSqlFlexibleServerOnlineResizeSupported Disabled { get; } = new PostgreSqlFlexibleServerOnlineResizeSupported(DisabledValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerOnlineResizeSupported"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServerOnlineResizeSupported left, PostgreSqlFlexibleServerOnlineResizeSupported right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerOnlineResizeSupported"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServerOnlineResizeSupported left, PostgreSqlFlexibleServerOnlineResizeSupported right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServerOnlineResizeSupported"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServerOnlineResizeSupported(string value) => new PostgreSqlFlexibleServerOnlineResizeSupported(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServerOnlineResizeSupported other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServerOnlineResizeSupported other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
