// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Represents a resource name availability. </summary>
    public partial class PostgreSqlFlexibleServerNameAvailabilityResult : PostgreSqlFlexibleServerNameAvailabilityResponse
    {
        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerNameAvailabilityResult"/>. </summary>
        internal PostgreSqlFlexibleServerNameAvailabilityResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> Indicates if the resource name is available. </param>
        /// <param name="reason"> The reason why the given name is not available. </param>
        /// <param name="message"> Detailed reason why the given name is available. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="name"> name of the PostgreSQL server. </param>
        /// <param name="resourceType"> type of the server. </param>
        internal PostgreSqlFlexibleServerNameAvailabilityResult(bool? isNameAvailable, PostgreSqlFlexibleServerNameUnavailableReason? reason, string message, IDictionary<string, BinaryData> serializedAdditionalRawData, string name, ResourceType? resourceType) : base(isNameAvailable, reason, message, serializedAdditionalRawData)
        {
            Name = name;
            ResourceType = resourceType;
        }

        /// <summary> name of the PostgreSQL server. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> type of the server. </summary>
        [WirePath("type")]
        public ResourceType? ResourceType { get; }
    }
}
