// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> High availability properties of a server. </summary>
    public partial class PostgreSqlFlexibleServerHighAvailability
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerHighAvailability"/>. </summary>
        public PostgreSqlFlexibleServerHighAvailability()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerHighAvailability"/>. </summary>
        /// <param name="mode"> The HA mode for the server. </param>
        /// <param name="state"> A state of a HA server that is visible to user. </param>
        /// <param name="standbyAvailabilityZone"> availability zone information of the standby. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PostgreSqlFlexibleServerHighAvailability(PostgreSqlFlexibleServerHighAvailabilityMode? mode, PostgreSqlFlexibleServerHAState? state, string standbyAvailabilityZone, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Mode = mode;
            State = state;
            StandbyAvailabilityZone = standbyAvailabilityZone;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The HA mode for the server. </summary>
        [WirePath("mode")]
        public PostgreSqlFlexibleServerHighAvailabilityMode? Mode { get; set; }
        /// <summary> A state of a HA server that is visible to user. </summary>
        [WirePath("state")]
        public PostgreSqlFlexibleServerHAState? State { get; }
        /// <summary> availability zone information of the standby. </summary>
        [WirePath("standbyAvailabilityZone")]
        public string StandbyAvailabilityZone { get; set; }
    }
}
