// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> A state of a HA server that is visible to user. </summary>
    public readonly partial struct PostgreSqlFlexibleServerHAState : IEquatable<PostgreSqlFlexibleServerHAState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerHAState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServerHAState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotEnabledValue = "NotEnabled";
        private const string CreatingStandbyValue = "CreatingStandby";
        private const string ReplicatingDataValue = "ReplicatingData";
        private const string FailingOverValue = "FailingOver";
        private const string HealthyValue = "Healthy";
        private const string RemovingStandbyValue = "RemovingStandby";

        /// <summary> NotEnabled. </summary>
        public static PostgreSqlFlexibleServerHAState NotEnabled { get; } = new PostgreSqlFlexibleServerHAState(NotEnabledValue);
        /// <summary> CreatingStandby. </summary>
        public static PostgreSqlFlexibleServerHAState CreatingStandby { get; } = new PostgreSqlFlexibleServerHAState(CreatingStandbyValue);
        /// <summary> ReplicatingData. </summary>
        public static PostgreSqlFlexibleServerHAState ReplicatingData { get; } = new PostgreSqlFlexibleServerHAState(ReplicatingDataValue);
        /// <summary> FailingOver. </summary>
        public static PostgreSqlFlexibleServerHAState FailingOver { get; } = new PostgreSqlFlexibleServerHAState(FailingOverValue);
        /// <summary> Healthy. </summary>
        public static PostgreSqlFlexibleServerHAState Healthy { get; } = new PostgreSqlFlexibleServerHAState(HealthyValue);
        /// <summary> RemovingStandby. </summary>
        public static PostgreSqlFlexibleServerHAState RemovingStandby { get; } = new PostgreSqlFlexibleServerHAState(RemovingStandbyValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerHAState"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServerHAState left, PostgreSqlFlexibleServerHAState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerHAState"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServerHAState left, PostgreSqlFlexibleServerHAState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServerHAState"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServerHAState(string value) => new PostgreSqlFlexibleServerHAState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServerHAState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServerHAState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
