// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Determines if geo-backup is supported in this region. "Enabled" means geo-backup is supported. "Disabled" stands for geo-back is not supported. </summary>
    public readonly partial struct PostgreSqlFlexibleServerGeoBackupSupported : IEquatable<PostgreSqlFlexibleServerGeoBackupSupported>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerGeoBackupSupported"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServerGeoBackupSupported(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static PostgreSqlFlexibleServerGeoBackupSupported Enabled { get; } = new PostgreSqlFlexibleServerGeoBackupSupported(EnabledValue);
        /// <summary> Disabled. </summary>
        public static PostgreSqlFlexibleServerGeoBackupSupported Disabled { get; } = new PostgreSqlFlexibleServerGeoBackupSupported(DisabledValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerGeoBackupSupported"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServerGeoBackupSupported left, PostgreSqlFlexibleServerGeoBackupSupported right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerGeoBackupSupported"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServerGeoBackupSupported left, PostgreSqlFlexibleServerGeoBackupSupported right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServerGeoBackupSupported"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServerGeoBackupSupported(string value) => new PostgreSqlFlexibleServerGeoBackupSupported(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServerGeoBackupSupported other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServerGeoBackupSupported other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
