// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> If Enabled, Azure Active Directory authentication is enabled. </summary>
    public readonly partial struct PostgreSqlFlexibleServerActiveDirectoryAuthEnum : IEquatable<PostgreSqlFlexibleServerActiveDirectoryAuthEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerActiveDirectoryAuthEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServerActiveDirectoryAuthEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static PostgreSqlFlexibleServerActiveDirectoryAuthEnum Enabled { get; } = new PostgreSqlFlexibleServerActiveDirectoryAuthEnum(EnabledValue);
        /// <summary> Disabled. </summary>
        public static PostgreSqlFlexibleServerActiveDirectoryAuthEnum Disabled { get; } = new PostgreSqlFlexibleServerActiveDirectoryAuthEnum(DisabledValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerActiveDirectoryAuthEnum"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServerActiveDirectoryAuthEnum left, PostgreSqlFlexibleServerActiveDirectoryAuthEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerActiveDirectoryAuthEnum"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServerActiveDirectoryAuthEnum left, PostgreSqlFlexibleServerActiveDirectoryAuthEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServerActiveDirectoryAuthEnum"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServerActiveDirectoryAuthEnum(string value) => new PostgreSqlFlexibleServerActiveDirectoryAuthEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServerActiveDirectoryAuthEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServerActiveDirectoryAuthEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
