// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Supported types of migration request include Validate, Migrate and ValidateAndMigrate. </summary>
    public readonly partial struct MigrationOption : IEquatable<MigrationOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MigrationOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MigrationOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ValidateValue = "Validate";
        private const string MigrateValue = "Migrate";
        private const string ValidateAndMigrateValue = "ValidateAndMigrate";

        /// <summary> Validate. </summary>
        public static MigrationOption Validate { get; } = new MigrationOption(ValidateValue);
        /// <summary> Migrate. </summary>
        public static MigrationOption Migrate { get; } = new MigrationOption(MigrateValue);
        /// <summary> ValidateAndMigrate. </summary>
        public static MigrationOption ValidateAndMigrate { get; } = new MigrationOption(ValidateAndMigrateValue);
        /// <summary> Determines if two <see cref="MigrationOption"/> values are the same. </summary>
        public static bool operator ==(MigrationOption left, MigrationOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MigrationOption"/> values are not the same. </summary>
        public static bool operator !=(MigrationOption left, MigrationOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MigrationOption"/>. </summary>
        public static implicit operator MigrationOption(string value) => new MigrationOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MigrationOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MigrationOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
