// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> To migrate roles and permissions we need to send this flag as True. </summary>
    public readonly partial struct MigrateRolesEnum : IEquatable<MigrateRolesEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MigrateRolesEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MigrateRolesEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static MigrateRolesEnum True { get; } = new MigrateRolesEnum(TrueValue);
        /// <summary> False. </summary>
        public static MigrateRolesEnum False { get; } = new MigrateRolesEnum(FalseValue);
        /// <summary> Determines if two <see cref="MigrateRolesEnum"/> values are the same. </summary>
        public static bool operator ==(MigrateRolesEnum left, MigrateRolesEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MigrateRolesEnum"/> values are not the same. </summary>
        public static bool operator !=(MigrateRolesEnum left, MigrateRolesEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MigrateRolesEnum"/>. </summary>
        public static implicit operator MigrateRolesEnum(string value) => new MigrateRolesEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MigrateRolesEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MigrateRolesEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
