// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Migration status of an individual database. </summary>
    public partial class DbMigrationStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DbMigrationStatus"/>. </summary>
        internal DbMigrationStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DbMigrationStatus"/>. </summary>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="migrationState"> Migration db state of an individual database. </param>
        /// <param name="migrationOperation"> Migration operation of an individual database. </param>
        /// <param name="startedOn"> Start date-time of a migration state. </param>
        /// <param name="endedOn"> End date-time of a migration state. </param>
        /// <param name="fullLoadQueuedTables"> Number of tables queued for the migration of a DB. </param>
        /// <param name="fullLoadErroredTables"> Number of tables errored out during the migration of a DB. </param>
        /// <param name="fullLoadLoadingTables"> Number of tables loading during the migration of a DB. </param>
        /// <param name="fullLoadCompletedTables"> Number of tables loaded during the migration of a DB. </param>
        /// <param name="cdcUpdateCounter"> CDC update counter. </param>
        /// <param name="cdcDeleteCounter"> CDC delete counter. </param>
        /// <param name="cdcInsertCounter"> CDC insert counter. </param>
        /// <param name="appliedChanges"> CDC applied changes counter. </param>
        /// <param name="incomingChanges"> CDC incoming changes counter. </param>
        /// <param name="latency"> Lag in seconds between source and target during online phase. </param>
        /// <param name="message"> Error message, if any, for the migration state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DbMigrationStatus(string databaseName, MigrationDbState? migrationState, string migrationOperation, DateTimeOffset? startedOn, DateTimeOffset? endedOn, int? fullLoadQueuedTables, int? fullLoadErroredTables, int? fullLoadLoadingTables, int? fullLoadCompletedTables, int? cdcUpdateCounter, int? cdcDeleteCounter, int? cdcInsertCounter, int? appliedChanges, int? incomingChanges, int? latency, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DatabaseName = databaseName;
            MigrationState = migrationState;
            MigrationOperation = migrationOperation;
            StartedOn = startedOn;
            EndedOn = endedOn;
            FullLoadQueuedTables = fullLoadQueuedTables;
            FullLoadErroredTables = fullLoadErroredTables;
            FullLoadLoadingTables = fullLoadLoadingTables;
            FullLoadCompletedTables = fullLoadCompletedTables;
            CdcUpdateCounter = cdcUpdateCounter;
            CdcDeleteCounter = cdcDeleteCounter;
            CdcInsertCounter = cdcInsertCounter;
            AppliedChanges = appliedChanges;
            IncomingChanges = incomingChanges;
            Latency = latency;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the database. </summary>
        [WirePath("databaseName")]
        public string DatabaseName { get; }
        /// <summary> Migration db state of an individual database. </summary>
        [WirePath("migrationState")]
        public MigrationDbState? MigrationState { get; }
        /// <summary> Migration operation of an individual database. </summary>
        [WirePath("migrationOperation")]
        public string MigrationOperation { get; }
        /// <summary> Start date-time of a migration state. </summary>
        [WirePath("startedOn")]
        public DateTimeOffset? StartedOn { get; }
        /// <summary> End date-time of a migration state. </summary>
        [WirePath("endedOn")]
        public DateTimeOffset? EndedOn { get; }
        /// <summary> Number of tables queued for the migration of a DB. </summary>
        [WirePath("fullLoadQueuedTables")]
        public int? FullLoadQueuedTables { get; }
        /// <summary> Number of tables errored out during the migration of a DB. </summary>
        [WirePath("fullLoadErroredTables")]
        public int? FullLoadErroredTables { get; }
        /// <summary> Number of tables loading during the migration of a DB. </summary>
        [WirePath("fullLoadLoadingTables")]
        public int? FullLoadLoadingTables { get; }
        /// <summary> Number of tables loaded during the migration of a DB. </summary>
        [WirePath("fullLoadCompletedTables")]
        public int? FullLoadCompletedTables { get; }
        /// <summary> CDC update counter. </summary>
        [WirePath("cdcUpdateCounter")]
        public int? CdcUpdateCounter { get; }
        /// <summary> CDC delete counter. </summary>
        [WirePath("cdcDeleteCounter")]
        public int? CdcDeleteCounter { get; }
        /// <summary> CDC insert counter. </summary>
        [WirePath("cdcInsertCounter")]
        public int? CdcInsertCounter { get; }
        /// <summary> CDC applied changes counter. </summary>
        [WirePath("appliedChanges")]
        public int? AppliedChanges { get; }
        /// <summary> CDC incoming changes counter. </summary>
        [WirePath("incomingChanges")]
        public int? IncomingChanges { get; }
        /// <summary> Lag in seconds between source and target during online phase. </summary>
        [WirePath("latency")]
        public int? Latency { get; }
        /// <summary> Error message, if any, for the migration state. </summary>
        [WirePath("message")]
        public string Message { get; }
    }
}
