// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    public partial class DbMigrationStatus : IUtf8JsonSerializable, IJsonModel<DbMigrationStatus>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DbMigrationStatus>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DbMigrationStatus>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DbMigrationStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DbMigrationStatus)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(DatabaseName))
            {
                writer.WritePropertyName("databaseName"u8);
                writer.WriteStringValue(DatabaseName);
            }
            if (Optional.IsDefined(MigrationState))
            {
                writer.WritePropertyName("migrationState"u8);
                writer.WriteStringValue(MigrationState.Value.ToString());
            }
            if (Optional.IsDefined(MigrationOperation))
            {
                writer.WritePropertyName("migrationOperation"u8);
                writer.WriteStringValue(MigrationOperation);
            }
            if (Optional.IsDefined(StartedOn))
            {
                writer.WritePropertyName("startedOn"u8);
                writer.WriteStringValue(StartedOn.Value, "O");
            }
            if (Optional.IsDefined(EndedOn))
            {
                writer.WritePropertyName("endedOn"u8);
                writer.WriteStringValue(EndedOn.Value, "O");
            }
            if (Optional.IsDefined(FullLoadQueuedTables))
            {
                writer.WritePropertyName("fullLoadQueuedTables"u8);
                writer.WriteNumberValue(FullLoadQueuedTables.Value);
            }
            if (Optional.IsDefined(FullLoadErroredTables))
            {
                writer.WritePropertyName("fullLoadErroredTables"u8);
                writer.WriteNumberValue(FullLoadErroredTables.Value);
            }
            if (Optional.IsDefined(FullLoadLoadingTables))
            {
                writer.WritePropertyName("fullLoadLoadingTables"u8);
                writer.WriteNumberValue(FullLoadLoadingTables.Value);
            }
            if (Optional.IsDefined(FullLoadCompletedTables))
            {
                writer.WritePropertyName("fullLoadCompletedTables"u8);
                writer.WriteNumberValue(FullLoadCompletedTables.Value);
            }
            if (Optional.IsDefined(CdcUpdateCounter))
            {
                writer.WritePropertyName("cdcUpdateCounter"u8);
                writer.WriteNumberValue(CdcUpdateCounter.Value);
            }
            if (Optional.IsDefined(CdcDeleteCounter))
            {
                writer.WritePropertyName("cdcDeleteCounter"u8);
                writer.WriteNumberValue(CdcDeleteCounter.Value);
            }
            if (Optional.IsDefined(CdcInsertCounter))
            {
                writer.WritePropertyName("cdcInsertCounter"u8);
                writer.WriteNumberValue(CdcInsertCounter.Value);
            }
            if (Optional.IsDefined(AppliedChanges))
            {
                writer.WritePropertyName("appliedChanges"u8);
                writer.WriteNumberValue(AppliedChanges.Value);
            }
            if (Optional.IsDefined(IncomingChanges))
            {
                writer.WritePropertyName("incomingChanges"u8);
                writer.WriteNumberValue(IncomingChanges.Value);
            }
            if (Optional.IsDefined(Latency))
            {
                writer.WritePropertyName("latency"u8);
                writer.WriteNumberValue(Latency.Value);
            }
            if (Optional.IsDefined(Message))
            {
                writer.WritePropertyName("message"u8);
                writer.WriteStringValue(Message);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DbMigrationStatus IJsonModel<DbMigrationStatus>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DbMigrationStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DbMigrationStatus)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDbMigrationStatus(document.RootElement, options);
        }

        internal static DbMigrationStatus DeserializeDbMigrationStatus(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string databaseName = default;
            MigrationDbState? migrationState = default;
            string migrationOperation = default;
            DateTimeOffset? startedOn = default;
            DateTimeOffset? endedOn = default;
            int? fullLoadQueuedTables = default;
            int? fullLoadErroredTables = default;
            int? fullLoadLoadingTables = default;
            int? fullLoadCompletedTables = default;
            int? cdcUpdateCounter = default;
            int? cdcDeleteCounter = default;
            int? cdcInsertCounter = default;
            int? appliedChanges = default;
            int? incomingChanges = default;
            int? latency = default;
            string message = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("databaseName"u8))
                {
                    databaseName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("migrationState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    migrationState = new MigrationDbState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("migrationOperation"u8))
                {
                    migrationOperation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("startedOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startedOn = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("endedOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    endedOn = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("fullLoadQueuedTables"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fullLoadQueuedTables = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("fullLoadErroredTables"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fullLoadErroredTables = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("fullLoadLoadingTables"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fullLoadLoadingTables = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("fullLoadCompletedTables"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fullLoadCompletedTables = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("cdcUpdateCounter"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cdcUpdateCounter = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("cdcDeleteCounter"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cdcDeleteCounter = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("cdcInsertCounter"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cdcInsertCounter = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("appliedChanges"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    appliedChanges = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("incomingChanges"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    incomingChanges = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("latency"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    latency = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("message"u8))
                {
                    message = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DbMigrationStatus(
                databaseName,
                migrationState,
                migrationOperation,
                startedOn,
                endedOn,
                fullLoadQueuedTables,
                fullLoadErroredTables,
                fullLoadLoadingTables,
                fullLoadCompletedTables,
                cdcUpdateCounter,
                cdcDeleteCounter,
                cdcInsertCounter,
                appliedChanges,
                incomingChanges,
                latency,
                message,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DatabaseName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  databaseName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DatabaseName))
                {
                    builder.Append("  databaseName: ");
                    if (DatabaseName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DatabaseName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DatabaseName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MigrationState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  migrationState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MigrationState))
                {
                    builder.Append("  migrationState: ");
                    builder.AppendLine($"'{MigrationState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MigrationOperation), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  migrationOperation: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MigrationOperation))
                {
                    builder.Append("  migrationOperation: ");
                    if (MigrationOperation.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MigrationOperation}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MigrationOperation}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StartedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  startedOn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StartedOn))
                {
                    builder.Append("  startedOn: ");
                    var formattedDateTimeString = TypeFormatters.ToString(StartedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EndedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  endedOn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EndedOn))
                {
                    builder.Append("  endedOn: ");
                    var formattedDateTimeString = TypeFormatters.ToString(EndedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FullLoadQueuedTables), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  fullLoadQueuedTables: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FullLoadQueuedTables))
                {
                    builder.Append("  fullLoadQueuedTables: ");
                    builder.AppendLine($"{FullLoadQueuedTables.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FullLoadErroredTables), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  fullLoadErroredTables: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FullLoadErroredTables))
                {
                    builder.Append("  fullLoadErroredTables: ");
                    builder.AppendLine($"{FullLoadErroredTables.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FullLoadLoadingTables), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  fullLoadLoadingTables: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FullLoadLoadingTables))
                {
                    builder.Append("  fullLoadLoadingTables: ");
                    builder.AppendLine($"{FullLoadLoadingTables.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FullLoadCompletedTables), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  fullLoadCompletedTables: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FullLoadCompletedTables))
                {
                    builder.Append("  fullLoadCompletedTables: ");
                    builder.AppendLine($"{FullLoadCompletedTables.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CdcUpdateCounter), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  cdcUpdateCounter: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CdcUpdateCounter))
                {
                    builder.Append("  cdcUpdateCounter: ");
                    builder.AppendLine($"{CdcUpdateCounter.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CdcDeleteCounter), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  cdcDeleteCounter: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CdcDeleteCounter))
                {
                    builder.Append("  cdcDeleteCounter: ");
                    builder.AppendLine($"{CdcDeleteCounter.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CdcInsertCounter), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  cdcInsertCounter: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CdcInsertCounter))
                {
                    builder.Append("  cdcInsertCounter: ");
                    builder.AppendLine($"{CdcInsertCounter.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AppliedChanges), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  appliedChanges: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AppliedChanges))
                {
                    builder.Append("  appliedChanges: ");
                    builder.AppendLine($"{AppliedChanges.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IncomingChanges), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  incomingChanges: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IncomingChanges))
                {
                    builder.Append("  incomingChanges: ");
                    builder.AppendLine($"{IncomingChanges.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Latency), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  latency: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Latency))
                {
                    builder.Append("  latency: ");
                    builder.AppendLine($"{Latency.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Message), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  message: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Message))
                {
                    builder.Append("  message: ");
                    if (Message.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Message}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Message}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<DbMigrationStatus>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DbMigrationStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(DbMigrationStatus)} does not support writing '{options.Format}' format.");
            }
        }

        DbMigrationStatus IPersistableModel<DbMigrationStatus>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DbMigrationStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDbMigrationStatus(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DbMigrationStatus)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DbMigrationStatus>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
