// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Validation status summary for an individual database. </summary>
    public partial class DbLevelValidationStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DbLevelValidationStatus"/>. </summary>
        internal DbLevelValidationStatus()
        {
            Summary = new ChangeTrackingList<ValidationSummaryItem>();
        }

        /// <summary> Initializes a new instance of <see cref="DbLevelValidationStatus"/>. </summary>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="startedOn"> Start date-time of a database level validation. </param>
        /// <param name="endedOn"> End date-time of a database level validation. </param>
        /// <param name="summary"> Summary of database level validations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DbLevelValidationStatus(string databaseName, DateTimeOffset? startedOn, DateTimeOffset? endedOn, IReadOnlyList<ValidationSummaryItem> summary, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DatabaseName = databaseName;
            StartedOn = startedOn;
            EndedOn = endedOn;
            Summary = summary;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the database. </summary>
        [WirePath("databaseName")]
        public string DatabaseName { get; }
        /// <summary> Start date-time of a database level validation. </summary>
        [WirePath("startedOn")]
        public DateTimeOffset? StartedOn { get; }
        /// <summary> End date-time of a database level validation. </summary>
        [WirePath("endedOn")]
        public DateTimeOffset? EndedOn { get; }
        /// <summary> Summary of database level validations. </summary>
        [WirePath("summary")]
        public IReadOnlyList<ValidationSummaryItem> Summary { get; }
    }
}
