// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers
{
    internal class ServerThreatProtectionSettingsModelOperationSource : IOperationSource<ServerThreatProtectionSettingsModelResource>
    {
        private readonly ArmClient _client;

        internal ServerThreatProtectionSettingsModelOperationSource(ArmClient client)
        {
            _client = client;
        }

        ServerThreatProtectionSettingsModelResource IOperationSource<ServerThreatProtectionSettingsModelResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ServerThreatProtectionSettingsModelData.DeserializeServerThreatProtectionSettingsModelData(document.RootElement);
            return new ServerThreatProtectionSettingsModelResource(_client, data);
        }

        async ValueTask<ServerThreatProtectionSettingsModelResource> IOperationSource<ServerThreatProtectionSettingsModelResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ServerThreatProtectionSettingsModelData.DeserializeServerThreatProtectionSettingsModelData(document.RootElement);
            return new ServerThreatProtectionSettingsModelResource(_client, data);
        }
    }
}
