// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers
{
    internal class PostgreSqlFlexibleServersPrivateEndpointConnectionOperationSource : IOperationSource<PostgreSqlFlexibleServersPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal PostgreSqlFlexibleServersPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        PostgreSqlFlexibleServersPrivateEndpointConnectionResource IOperationSource<PostgreSqlFlexibleServersPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PostgreSqlFlexibleServersPrivateEndpointConnectionData.DeserializePostgreSqlFlexibleServersPrivateEndpointConnectionData(document.RootElement);
            return new PostgreSqlFlexibleServersPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<PostgreSqlFlexibleServersPrivateEndpointConnectionResource> IOperationSource<PostgreSqlFlexibleServersPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PostgreSqlFlexibleServersPrivateEndpointConnectionData.DeserializePostgreSqlFlexibleServersPrivateEndpointConnectionData(document.RootElement);
            return new PostgreSqlFlexibleServersPrivateEndpointConnectionResource(_client, data);
        }
    }
}
