// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers
{
    internal class PostgreSqlFlexibleServerOperationSource : IOperationSource<PostgreSqlFlexibleServerResource>
    {
        private readonly ArmClient _client;

        internal PostgreSqlFlexibleServerOperationSource(ArmClient client)
        {
            _client = client;
        }

        PostgreSqlFlexibleServerResource IOperationSource<PostgreSqlFlexibleServerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PostgreSqlFlexibleServerData.DeserializePostgreSqlFlexibleServerData(document.RootElement);
            return new PostgreSqlFlexibleServerResource(_client, data);
        }

        async ValueTask<PostgreSqlFlexibleServerResource> IOperationSource<PostgreSqlFlexibleServerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PostgreSqlFlexibleServerData.DeserializePostgreSqlFlexibleServerData(document.RootElement);
            return new PostgreSqlFlexibleServerResource(_client, data);
        }
    }
}
