// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers
{
    internal class PostgreSqlFlexibleServerActiveDirectoryAdministratorOperationSource : IOperationSource<PostgreSqlFlexibleServerActiveDirectoryAdministratorResource>
    {
        private readonly ArmClient _client;

        internal PostgreSqlFlexibleServerActiveDirectoryAdministratorOperationSource(ArmClient client)
        {
            _client = client;
        }

        PostgreSqlFlexibleServerActiveDirectoryAdministratorResource IOperationSource<PostgreSqlFlexibleServerActiveDirectoryAdministratorResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PostgreSqlFlexibleServerActiveDirectoryAdministratorData.DeserializePostgreSqlFlexibleServerActiveDirectoryAdministratorData(document.RootElement);
            return new PostgreSqlFlexibleServerActiveDirectoryAdministratorResource(_client, data);
        }

        async ValueTask<PostgreSqlFlexibleServerActiveDirectoryAdministratorResource> IOperationSource<PostgreSqlFlexibleServerActiveDirectoryAdministratorResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PostgreSqlFlexibleServerActiveDirectoryAdministratorData.DeserializePostgreSqlFlexibleServerActiveDirectoryAdministratorData(document.RootElement);
            return new PostgreSqlFlexibleServerActiveDirectoryAdministratorResource(_client, data);
        }
    }
}
