// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockablePostgreSqlFlexibleServersArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockablePostgreSqlFlexibleServersArmClient"/> class for mocking. </summary>
        protected MockablePostgreSqlFlexibleServersArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockablePostgreSqlFlexibleServersArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockablePostgreSqlFlexibleServersArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockablePostgreSqlFlexibleServersArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlFlexibleServerActiveDirectoryAdministratorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlFlexibleServerActiveDirectoryAdministratorResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlFlexibleServerActiveDirectoryAdministratorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlFlexibleServerActiveDirectoryAdministratorResource"/> object. </returns>
        public virtual PostgreSqlFlexibleServerActiveDirectoryAdministratorResource GetPostgreSqlFlexibleServerActiveDirectoryAdministratorResource(ResourceIdentifier id)
        {
            PostgreSqlFlexibleServerActiveDirectoryAdministratorResource.ValidateResourceId(id);
            return new PostgreSqlFlexibleServerActiveDirectoryAdministratorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlFlexibleServerBackupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlFlexibleServerBackupResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlFlexibleServerBackupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlFlexibleServerBackupResource"/> object. </returns>
        public virtual PostgreSqlFlexibleServerBackupResource GetPostgreSqlFlexibleServerBackupResource(ResourceIdentifier id)
        {
            PostgreSqlFlexibleServerBackupResource.ValidateResourceId(id);
            return new PostgreSqlFlexibleServerBackupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlFlexibleServerConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlFlexibleServerConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlFlexibleServerConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlFlexibleServerConfigurationResource"/> object. </returns>
        public virtual PostgreSqlFlexibleServerConfigurationResource GetPostgreSqlFlexibleServerConfigurationResource(ResourceIdentifier id)
        {
            PostgreSqlFlexibleServerConfigurationResource.ValidateResourceId(id);
            return new PostgreSqlFlexibleServerConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlFlexibleServerDatabaseResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlFlexibleServerDatabaseResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlFlexibleServerDatabaseResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlFlexibleServerDatabaseResource"/> object. </returns>
        public virtual PostgreSqlFlexibleServerDatabaseResource GetPostgreSqlFlexibleServerDatabaseResource(ResourceIdentifier id)
        {
            PostgreSqlFlexibleServerDatabaseResource.ValidateResourceId(id);
            return new PostgreSqlFlexibleServerDatabaseResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlFlexibleServerFirewallRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlFlexibleServerFirewallRuleResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlFlexibleServerFirewallRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlFlexibleServerFirewallRuleResource"/> object. </returns>
        public virtual PostgreSqlFlexibleServerFirewallRuleResource GetPostgreSqlFlexibleServerFirewallRuleResource(ResourceIdentifier id)
        {
            PostgreSqlFlexibleServerFirewallRuleResource.ValidateResourceId(id);
            return new PostgreSqlFlexibleServerFirewallRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlFlexibleServerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlFlexibleServerResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlFlexibleServerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlFlexibleServerResource"/> object. </returns>
        public virtual PostgreSqlFlexibleServerResource GetPostgreSqlFlexibleServerResource(ResourceIdentifier id)
        {
            PostgreSqlFlexibleServerResource.ValidateResourceId(id);
            return new PostgreSqlFlexibleServerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlLtrServerBackupOperationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlLtrServerBackupOperationResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlLtrServerBackupOperationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlLtrServerBackupOperationResource"/> object. </returns>
        public virtual PostgreSqlLtrServerBackupOperationResource GetPostgreSqlLtrServerBackupOperationResource(ResourceIdentifier id)
        {
            PostgreSqlLtrServerBackupOperationResource.ValidateResourceId(id);
            return new PostgreSqlLtrServerBackupOperationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlMigrationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlMigrationResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlMigrationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlMigrationResource"/> object. </returns>
        public virtual PostgreSqlMigrationResource GetPostgreSqlMigrationResource(ResourceIdentifier id)
        {
            PostgreSqlMigrationResource.ValidateResourceId(id);
            return new PostgreSqlMigrationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlFlexibleServersPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlFlexibleServersPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlFlexibleServersPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlFlexibleServersPrivateEndpointConnectionResource"/> object. </returns>
        public virtual PostgreSqlFlexibleServersPrivateEndpointConnectionResource GetPostgreSqlFlexibleServersPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            PostgreSqlFlexibleServersPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new PostgreSqlFlexibleServersPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlFlexibleServersPrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlFlexibleServersPrivateLinkResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlFlexibleServersPrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlFlexibleServersPrivateLinkResource"/> object. </returns>
        public virtual PostgreSqlFlexibleServersPrivateLinkResource GetPostgreSqlFlexibleServersPrivateLinkResource(ResourceIdentifier id)
        {
            PostgreSqlFlexibleServersPrivateLinkResource.ValidateResourceId(id);
            return new PostgreSqlFlexibleServersPrivateLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServerThreatProtectionSettingsModelResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServerThreatProtectionSettingsModelResource.CreateResourceIdentifier" /> to create a <see cref="ServerThreatProtectionSettingsModelResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServerThreatProtectionSettingsModelResource"/> object. </returns>
        public virtual ServerThreatProtectionSettingsModelResource GetServerThreatProtectionSettingsModelResource(ResourceIdentifier id)
        {
            ServerThreatProtectionSettingsModelResource.ValidateResourceId(id);
            return new ServerThreatProtectionSettingsModelResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualEndpointResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualEndpointResource.CreateResourceIdentifier" /> to create a <see cref="VirtualEndpointResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualEndpointResource"/> object. </returns>
        public virtual VirtualEndpointResource GetVirtualEndpointResource(ResourceIdentifier id)
        {
            VirtualEndpointResource.ValidateResourceId(id);
            return new VirtualEndpointResource(Client, id);
        }
    }
}
