// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.PostgreSql.Models;

namespace Azure.ResourceManager.PostgreSql
{
    /// <summary>
    /// A class representing the PostgreSqlServerAdministrator data model.
    /// Represents a and external administrator to be created.
    /// </summary>
    public partial class PostgreSqlServerAdministratorData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlServerAdministratorData"/>. </summary>
        public PostgreSqlServerAdministratorData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlServerAdministratorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="administratorType"> The type of administrator. </param>
        /// <param name="loginAccountName"> The server administrator login account name. </param>
        /// <param name="secureId"> The server administrator Sid (Secure ID). </param>
        /// <param name="tenantId"> The server Active Directory Administrator tenant id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PostgreSqlServerAdministratorData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, PostgreSqlAdministratorType? administratorType, string loginAccountName, Guid? secureId, Guid? tenantId, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            AdministratorType = administratorType;
            LoginAccountName = loginAccountName;
            SecureId = secureId;
            TenantId = tenantId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of administrator. </summary>
        [WirePath("properties.administratorType")]
        public PostgreSqlAdministratorType? AdministratorType { get; set; }
        /// <summary> The server administrator login account name. </summary>
        [WirePath("properties.login")]
        public string LoginAccountName { get; set; }
        /// <summary> The server administrator Sid (Secure ID). </summary>
        [WirePath("properties.sid")]
        public Guid? SecureId { get; set; }
        /// <summary> The server Active Directory Administrator tenant id. </summary>
        [WirePath("properties.tenantId")]
        public Guid? TenantId { get; set; }
    }
}
