// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.Models
{
    /// <summary> The tier of the particular SKU, e.g. Basic. </summary>
    public readonly partial struct PostgreSqlSkuTier : IEquatable<PostgreSqlSkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlSkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlSkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string GeneralPurposeValue = "GeneralPurpose";
        private const string MemoryOptimizedValue = "MemoryOptimized";

        /// <summary> Basic. </summary>
        public static PostgreSqlSkuTier Basic { get; } = new PostgreSqlSkuTier(BasicValue);
        /// <summary> GeneralPurpose. </summary>
        public static PostgreSqlSkuTier GeneralPurpose { get; } = new PostgreSqlSkuTier(GeneralPurposeValue);
        /// <summary> MemoryOptimized. </summary>
        public static PostgreSqlSkuTier MemoryOptimized { get; } = new PostgreSqlSkuTier(MemoryOptimizedValue);
        /// <summary> Determines if two <see cref="PostgreSqlSkuTier"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlSkuTier left, PostgreSqlSkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlSkuTier"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlSkuTier left, PostgreSqlSkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlSkuTier"/>. </summary>
        public static implicit operator PostgreSqlSkuTier(string value) => new PostgreSqlSkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlSkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlSkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
