// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.Models
{
    /// <summary> The PostgreSqlSecurityAlertPolicyName. </summary>
    public readonly partial struct PostgreSqlSecurityAlertPolicyName : IEquatable<PostgreSqlSecurityAlertPolicyName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlSecurityAlertPolicyName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlSecurityAlertPolicyName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";

        /// <summary> Default. </summary>
        public static PostgreSqlSecurityAlertPolicyName Default { get; } = new PostgreSqlSecurityAlertPolicyName(DefaultValue);
        /// <summary> Determines if two <see cref="PostgreSqlSecurityAlertPolicyName"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlSecurityAlertPolicyName left, PostgreSqlSecurityAlertPolicyName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlSecurityAlertPolicyName"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlSecurityAlertPolicyName left, PostgreSqlSecurityAlertPolicyName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlSecurityAlertPolicyName"/>. </summary>
        public static implicit operator PostgreSqlSecurityAlertPolicyName(string value) => new PostgreSqlSecurityAlertPolicyName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlSecurityAlertPolicyName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlSecurityAlertPolicyName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
