// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.Models
{
    /// <summary> Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. </summary>
    public readonly partial struct PostgreSqlPublicNetworkAccessEnum : IEquatable<PostgreSqlPublicNetworkAccessEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlPublicNetworkAccessEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlPublicNetworkAccessEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static PostgreSqlPublicNetworkAccessEnum Enabled { get; } = new PostgreSqlPublicNetworkAccessEnum(EnabledValue);
        /// <summary> Disabled. </summary>
        public static PostgreSqlPublicNetworkAccessEnum Disabled { get; } = new PostgreSqlPublicNetworkAccessEnum(DisabledValue);
        /// <summary> Determines if two <see cref="PostgreSqlPublicNetworkAccessEnum"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlPublicNetworkAccessEnum left, PostgreSqlPublicNetworkAccessEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlPublicNetworkAccessEnum"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlPublicNetworkAccessEnum left, PostgreSqlPublicNetworkAccessEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlPublicNetworkAccessEnum"/>. </summary>
        public static implicit operator PostgreSqlPublicNetworkAccessEnum(string value) => new PostgreSqlPublicNetworkAccessEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlPublicNetworkAccessEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlPublicNetworkAccessEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
