// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.Models
{
    /// <summary> State of the private endpoint connection. </summary>
    public readonly partial struct PostgreSqlPrivateEndpointProvisioningState : IEquatable<PostgreSqlPrivateEndpointProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlPrivateEndpointProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlPrivateEndpointProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ApprovingValue = "Approving";
        private const string ReadyValue = "Ready";
        private const string DroppingValue = "Dropping";
        private const string FailedValue = "Failed";
        private const string RejectingValue = "Rejecting";

        /// <summary> Approving. </summary>
        public static PostgreSqlPrivateEndpointProvisioningState Approving { get; } = new PostgreSqlPrivateEndpointProvisioningState(ApprovingValue);
        /// <summary> Ready. </summary>
        public static PostgreSqlPrivateEndpointProvisioningState Ready { get; } = new PostgreSqlPrivateEndpointProvisioningState(ReadyValue);
        /// <summary> Dropping. </summary>
        public static PostgreSqlPrivateEndpointProvisioningState Dropping { get; } = new PostgreSqlPrivateEndpointProvisioningState(DroppingValue);
        /// <summary> Failed. </summary>
        public static PostgreSqlPrivateEndpointProvisioningState Failed { get; } = new PostgreSqlPrivateEndpointProvisioningState(FailedValue);
        /// <summary> Rejecting. </summary>
        public static PostgreSqlPrivateEndpointProvisioningState Rejecting { get; } = new PostgreSqlPrivateEndpointProvisioningState(RejectingValue);
        /// <summary> Determines if two <see cref="PostgreSqlPrivateEndpointProvisioningState"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlPrivateEndpointProvisioningState left, PostgreSqlPrivateEndpointProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlPrivateEndpointProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlPrivateEndpointProvisioningState left, PostgreSqlPrivateEndpointProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlPrivateEndpointProvisioningState"/>. </summary>
        public static implicit operator PostgreSqlPrivateEndpointProvisioningState(string value) => new PostgreSqlPrivateEndpointProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlPrivateEndpointProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlPrivateEndpointProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
