// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.Models
{
    /// <summary> The type of administrator. </summary>
    public readonly partial struct PostgreSqlAdministratorType : IEquatable<PostgreSqlAdministratorType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlAdministratorType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlAdministratorType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveDirectoryValue = "ActiveDirectory";

        /// <summary> ActiveDirectory. </summary>
        public static PostgreSqlAdministratorType ActiveDirectory { get; } = new PostgreSqlAdministratorType(ActiveDirectoryValue);
        /// <summary> Determines if two <see cref="PostgreSqlAdministratorType"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlAdministratorType left, PostgreSqlAdministratorType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlAdministratorType"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlAdministratorType left, PostgreSqlAdministratorType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlAdministratorType"/>. </summary>
        public static implicit operator PostgreSqlAdministratorType(string value) => new PostgreSqlAdministratorType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlAdministratorType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlAdministratorType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
