// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PostgreSql
{
    internal class PostgreSqlServerSecurityAlertPolicyOperationSource : IOperationSource<PostgreSqlServerSecurityAlertPolicyResource>
    {
        private readonly ArmClient _client;

        internal PostgreSqlServerSecurityAlertPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        PostgreSqlServerSecurityAlertPolicyResource IOperationSource<PostgreSqlServerSecurityAlertPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PostgreSqlServerSecurityAlertPolicyData.DeserializePostgreSqlServerSecurityAlertPolicyData(document.RootElement);
            return new PostgreSqlServerSecurityAlertPolicyResource(_client, data);
        }

        async ValueTask<PostgreSqlServerSecurityAlertPolicyResource> IOperationSource<PostgreSqlServerSecurityAlertPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PostgreSqlServerSecurityAlertPolicyData.DeserializePostgreSqlServerSecurityAlertPolicyData(document.RootElement);
            return new PostgreSqlServerSecurityAlertPolicyResource(_client, data);
        }
    }
}
