// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PostgreSql
{
    internal class PostgreSqlServerKeyOperationSource : IOperationSource<PostgreSqlServerKeyResource>
    {
        private readonly ArmClient _client;

        internal PostgreSqlServerKeyOperationSource(ArmClient client)
        {
            _client = client;
        }

        PostgreSqlServerKeyResource IOperationSource<PostgreSqlServerKeyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PostgreSqlServerKeyData.DeserializePostgreSqlServerKeyData(document.RootElement);
            return new PostgreSqlServerKeyResource(_client, data);
        }

        async ValueTask<PostgreSqlServerKeyResource> IOperationSource<PostgreSqlServerKeyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PostgreSqlServerKeyData.DeserializePostgreSqlServerKeyData(document.RootElement);
            return new PostgreSqlServerKeyResource(_client, data);
        }
    }
}
