// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PostgreSql
{
    internal class PostgreSqlDatabaseOperationSource : IOperationSource<PostgreSqlDatabaseResource>
    {
        private readonly ArmClient _client;

        internal PostgreSqlDatabaseOperationSource(ArmClient client)
        {
            _client = client;
        }

        PostgreSqlDatabaseResource IOperationSource<PostgreSqlDatabaseResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PostgreSqlDatabaseData.DeserializePostgreSqlDatabaseData(document.RootElement);
            return new PostgreSqlDatabaseResource(_client, data);
        }

        async ValueTask<PostgreSqlDatabaseResource> IOperationSource<PostgreSqlDatabaseResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PostgreSqlDatabaseData.DeserializePostgreSqlDatabaseData(document.RootElement);
            return new PostgreSqlDatabaseResource(_client, data);
        }
    }
}
