// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.PostgreSql.Models;

namespace Azure.ResourceManager.PostgreSql
{
    internal class PostgreSqlConfigurationListOperationSource : IOperationSource<PostgreSqlConfigurationList>
    {
        PostgreSqlConfigurationList IOperationSource<PostgreSqlConfigurationList>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return PostgreSqlConfigurationList.DeserializePostgreSqlConfigurationList(document.RootElement);
        }

        async ValueTask<PostgreSqlConfigurationList> IOperationSource<PostgreSqlConfigurationList>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return PostgreSqlConfigurationList.DeserializePostgreSqlConfigurationList(document.RootElement);
        }
    }
}
