// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.PostgreSql.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockablePostgreSqlArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockablePostgreSqlArmClient"/> class for mocking. </summary>
        protected MockablePostgreSqlArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockablePostgreSqlArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockablePostgreSqlArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockablePostgreSqlArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlServerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlServerResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlServerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlServerResource"/> object. </returns>
        public virtual PostgreSqlServerResource GetPostgreSqlServerResource(ResourceIdentifier id)
        {
            PostgreSqlServerResource.ValidateResourceId(id);
            return new PostgreSqlServerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlFirewallRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlFirewallRuleResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlFirewallRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlFirewallRuleResource"/> object. </returns>
        public virtual PostgreSqlFirewallRuleResource GetPostgreSqlFirewallRuleResource(ResourceIdentifier id)
        {
            PostgreSqlFirewallRuleResource.ValidateResourceId(id);
            return new PostgreSqlFirewallRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlVirtualNetworkRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlVirtualNetworkRuleResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlVirtualNetworkRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlVirtualNetworkRuleResource"/> object. </returns>
        public virtual PostgreSqlVirtualNetworkRuleResource GetPostgreSqlVirtualNetworkRuleResource(ResourceIdentifier id)
        {
            PostgreSqlVirtualNetworkRuleResource.ValidateResourceId(id);
            return new PostgreSqlVirtualNetworkRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlDatabaseResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlDatabaseResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlDatabaseResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlDatabaseResource"/> object. </returns>
        public virtual PostgreSqlDatabaseResource GetPostgreSqlDatabaseResource(ResourceIdentifier id)
        {
            PostgreSqlDatabaseResource.ValidateResourceId(id);
            return new PostgreSqlDatabaseResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlConfigurationResource"/> object. </returns>
        public virtual PostgreSqlConfigurationResource GetPostgreSqlConfigurationResource(ResourceIdentifier id)
        {
            PostgreSqlConfigurationResource.ValidateResourceId(id);
            return new PostgreSqlConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlServerAdministratorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlServerAdministratorResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlServerAdministratorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlServerAdministratorResource"/> object. </returns>
        public virtual PostgreSqlServerAdministratorResource GetPostgreSqlServerAdministratorResource(ResourceIdentifier id)
        {
            PostgreSqlServerAdministratorResource.ValidateResourceId(id);
            return new PostgreSqlServerAdministratorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlServerSecurityAlertPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlServerSecurityAlertPolicyResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlServerSecurityAlertPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlServerSecurityAlertPolicyResource"/> object. </returns>
        public virtual PostgreSqlServerSecurityAlertPolicyResource GetPostgreSqlServerSecurityAlertPolicyResource(ResourceIdentifier id)
        {
            PostgreSqlServerSecurityAlertPolicyResource.ValidateResourceId(id);
            return new PostgreSqlServerSecurityAlertPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlPrivateEndpointConnectionResource"/> object. </returns>
        public virtual PostgreSqlPrivateEndpointConnectionResource GetPostgreSqlPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            PostgreSqlPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new PostgreSqlPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlPrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlPrivateLinkResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlPrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlPrivateLinkResource"/> object. </returns>
        public virtual PostgreSqlPrivateLinkResource GetPostgreSqlPrivateLinkResource(ResourceIdentifier id)
        {
            PostgreSqlPrivateLinkResource.ValidateResourceId(id);
            return new PostgreSqlPrivateLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PostgreSqlServerKeyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PostgreSqlServerKeyResource.CreateResourceIdentifier" /> to create a <see cref="PostgreSqlServerKeyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PostgreSqlServerKeyResource"/> object. </returns>
        public virtual PostgreSqlServerKeyResource GetPostgreSqlServerKeyResource(ResourceIdentifier id)
        {
            PostgreSqlServerKeyResource.ValidateResourceId(id);
            return new PostgreSqlServerKeyResource(Client, id);
        }
    }
}
