// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.PolicyInsights.Models;

namespace Azure.ResourceManager.PolicyInsights
{
    internal partial class PolicyStatesRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of PolicyStatesRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public PolicyStatesRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2019-10-01";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateListQueryResultsForManagementGroupRequestUri(string managementGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Management", true);
            uri.AppendPath("/managementGroups/", false);
            uri.AppendPath(managementGroupName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForManagementGroupRequest(string managementGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Management", true);
            uri.AppendPath("/managementGroups/", false);
            uri.AppendPath(managementGroupName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the resources under the management group. </summary>
        /// <param name="managementGroupName"> Management group name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="managementGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="managementGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForManagementGroupAsync(string managementGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managementGroupName, nameof(managementGroupName));

            using var message = CreateListQueryResultsForManagementGroupRequest(managementGroupName, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the resources under the management group. </summary>
        /// <param name="managementGroupName"> Management group name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="managementGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="managementGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForManagementGroup(string managementGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managementGroupName, nameof(managementGroupName));

            using var message = CreateListQueryResultsForManagementGroupRequest(managementGroupName, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateSummarizeForManagementGroupRequestUri(string managementGroupName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Management", true);
            uri.AppendPath("/managementGroups/", false);
            uri.AppendPath(managementGroupName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            return uri;
        }

        internal HttpMessage CreateSummarizeForManagementGroupRequest(string managementGroupName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Management", true);
            uri.AppendPath("/managementGroups/", false);
            uri.AppendPath(managementGroupName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Summarizes policy states for the resources under the management group. </summary>
        /// <param name="managementGroupName"> Management group name. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="managementGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="managementGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SummarizeResults>> SummarizeForManagementGroupAsync(string managementGroupName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managementGroupName, nameof(managementGroupName));

            using var message = CreateSummarizeForManagementGroupRequest(managementGroupName, policyStateSummaryType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Summarizes policy states for the resources under the management group. </summary>
        /// <param name="managementGroupName"> Management group name. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="managementGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="managementGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SummarizeResults> SummarizeForManagementGroup(string managementGroupName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managementGroupName, nameof(managementGroupName));

            using var message = CreateSummarizeForManagementGroupRequest(managementGroupName, policyStateSummaryType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForSubscriptionRequestUri(string subscriptionId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForSubscriptionRequest(string subscriptionId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the resources under the subscription. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForSubscriptionAsync(string subscriptionId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateListQueryResultsForSubscriptionRequest(subscriptionId, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the resources under the subscription. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForSubscription(string subscriptionId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateListQueryResultsForSubscriptionRequest(subscriptionId, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateSummarizeForSubscriptionRequestUri(string subscriptionId, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            return uri;
        }

        internal HttpMessage CreateSummarizeForSubscriptionRequest(string subscriptionId, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Summarizes policy states for the resources under the subscription. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SummarizeResults>> SummarizeForSubscriptionAsync(string subscriptionId, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateSummarizeForSubscriptionRequest(subscriptionId, policyStateSummaryType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Summarizes policy states for the resources under the subscription. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SummarizeResults> SummarizeForSubscription(string subscriptionId, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateSummarizeForSubscriptionRequest(subscriptionId, policyStateSummaryType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForResourceGroupRequestUri(string subscriptionId, string resourceGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForResourceGroupRequest(string subscriptionId, string resourceGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the resources under the resource group. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForResourceGroupAsync(string subscriptionId, string resourceGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));

            using var message = CreateListQueryResultsForResourceGroupRequest(subscriptionId, resourceGroupName, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the resources under the resource group. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForResourceGroup(string subscriptionId, string resourceGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));

            using var message = CreateListQueryResultsForResourceGroupRequest(subscriptionId, resourceGroupName, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateSummarizeForResourceGroupRequestUri(string subscriptionId, string resourceGroupName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            return uri;
        }

        internal HttpMessage CreateSummarizeForResourceGroupRequest(string subscriptionId, string resourceGroupName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Summarizes policy states for the resources under the resource group. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SummarizeResults>> SummarizeForResourceGroupAsync(string subscriptionId, string resourceGroupName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));

            using var message = CreateSummarizeForResourceGroupRequest(subscriptionId, resourceGroupName, policyStateSummaryType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Summarizes policy states for the resources under the resource group. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SummarizeResults> SummarizeForResourceGroup(string subscriptionId, string resourceGroupName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));

            using var message = CreateSummarizeForResourceGroupRequest(subscriptionId, resourceGroupName, policyStateSummaryType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForResourceRequestUri(string resourceId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(resourceId, false);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.Expand != null)
            {
                uri.AppendQuery("$expand", policyQuerySettings.Expand, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForResourceRequest(string resourceId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(resourceId, false);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.Expand != null)
            {
                uri.AppendQuery("$expand", policyQuerySettings.Expand, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the resource. </summary>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> is null. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForResourceAsync(string resourceId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));

            using var message = CreateListQueryResultsForResourceRequest(resourceId, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the resource. </summary>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> is null. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForResource(string resourceId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));

            using var message = CreateListQueryResultsForResourceRequest(resourceId, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateSummarizeForResourceRequestUri(string resourceId, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(resourceId, false);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            return uri;
        }

        internal HttpMessage CreateSummarizeForResourceRequest(string resourceId, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(resourceId, false);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Summarizes policy states for the resource. </summary>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> is null. </exception>
        public async Task<Response<SummarizeResults>> SummarizeForResourceAsync(string resourceId, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));

            using var message = CreateSummarizeForResourceRequest(resourceId, policyStateSummaryType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Summarizes policy states for the resource. </summary>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> is null. </exception>
        public Response<SummarizeResults> SummarizeForResource(string resourceId, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));

            using var message = CreateSummarizeForResourceRequest(resourceId, policyStateSummaryType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateTriggerSubscriptionEvaluationRequestUri(string subscriptionId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateTriggerSubscriptionEvaluationRequest(string subscriptionId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Triggers a policy evaluation scan for all the resources under the subscription. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> TriggerSubscriptionEvaluationAsync(string subscriptionId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateTriggerSubscriptionEvaluationRequest(subscriptionId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Triggers a policy evaluation scan for all the resources under the subscription. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response TriggerSubscriptionEvaluation(string subscriptionId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateTriggerSubscriptionEvaluationRequest(subscriptionId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateTriggerResourceGroupEvaluationRequestUri(string subscriptionId, string resourceGroupName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateTriggerResourceGroupEvaluationRequest(string subscriptionId, string resourceGroupName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Triggers a policy evaluation scan for all the resources under the resource group. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> TriggerResourceGroupEvaluationAsync(string subscriptionId, string resourceGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));

            using var message = CreateTriggerResourceGroupEvaluationRequest(subscriptionId, resourceGroupName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Triggers a policy evaluation scan for all the resources under the resource group. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response TriggerResourceGroupEvaluation(string subscriptionId, string resourceGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));

            using var message = CreateTriggerResourceGroupEvaluationRequest(subscriptionId, resourceGroupName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForPolicySetDefinitionRequestUri(string subscriptionId, string policySetDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policySetDefinitions/", false);
            uri.AppendPath(policySetDefinitionName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForPolicySetDefinitionRequest(string subscriptionId, string policySetDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policySetDefinitions/", false);
            uri.AppendPath(policySetDefinitionName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the subscription level policy set definition. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policySetDefinitionName"> Policy set definition name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="policySetDefinitionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policySetDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForPolicySetDefinitionAsync(string subscriptionId, string policySetDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policySetDefinitionName, nameof(policySetDefinitionName));

            using var message = CreateListQueryResultsForPolicySetDefinitionRequest(subscriptionId, policySetDefinitionName, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the subscription level policy set definition. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policySetDefinitionName"> Policy set definition name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="policySetDefinitionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policySetDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForPolicySetDefinition(string subscriptionId, string policySetDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policySetDefinitionName, nameof(policySetDefinitionName));

            using var message = CreateListQueryResultsForPolicySetDefinitionRequest(subscriptionId, policySetDefinitionName, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateSummarizeForPolicySetDefinitionRequestUri(string subscriptionId, string policySetDefinitionName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policySetDefinitions/", false);
            uri.AppendPath(policySetDefinitionName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            return uri;
        }

        internal HttpMessage CreateSummarizeForPolicySetDefinitionRequest(string subscriptionId, string policySetDefinitionName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policySetDefinitions/", false);
            uri.AppendPath(policySetDefinitionName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Summarizes policy states for the subscription level policy set definition. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policySetDefinitionName"> Policy set definition name. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="policySetDefinitionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policySetDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SummarizeResults>> SummarizeForPolicySetDefinitionAsync(string subscriptionId, string policySetDefinitionName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policySetDefinitionName, nameof(policySetDefinitionName));

            using var message = CreateSummarizeForPolicySetDefinitionRequest(subscriptionId, policySetDefinitionName, policyStateSummaryType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Summarizes policy states for the subscription level policy set definition. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policySetDefinitionName"> Policy set definition name. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="policySetDefinitionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policySetDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SummarizeResults> SummarizeForPolicySetDefinition(string subscriptionId, string policySetDefinitionName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policySetDefinitionName, nameof(policySetDefinitionName));

            using var message = CreateSummarizeForPolicySetDefinitionRequest(subscriptionId, policySetDefinitionName, policyStateSummaryType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForPolicyDefinitionRequestUri(string subscriptionId, string policyDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policyDefinitions/", false);
            uri.AppendPath(policyDefinitionName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForPolicyDefinitionRequest(string subscriptionId, string policyDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policyDefinitions/", false);
            uri.AppendPath(policyDefinitionName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the subscription level policy definition. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyDefinitionName"> Policy definition name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="policyDefinitionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policyDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForPolicyDefinitionAsync(string subscriptionId, string policyDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policyDefinitionName, nameof(policyDefinitionName));

            using var message = CreateListQueryResultsForPolicyDefinitionRequest(subscriptionId, policyDefinitionName, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the subscription level policy definition. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyDefinitionName"> Policy definition name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="policyDefinitionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policyDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForPolicyDefinition(string subscriptionId, string policyDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policyDefinitionName, nameof(policyDefinitionName));

            using var message = CreateListQueryResultsForPolicyDefinitionRequest(subscriptionId, policyDefinitionName, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateSummarizeForPolicyDefinitionRequestUri(string subscriptionId, string policyDefinitionName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policyDefinitions/", false);
            uri.AppendPath(policyDefinitionName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            return uri;
        }

        internal HttpMessage CreateSummarizeForPolicyDefinitionRequest(string subscriptionId, string policyDefinitionName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policyDefinitions/", false);
            uri.AppendPath(policyDefinitionName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Summarizes policy states for the subscription level policy definition. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyDefinitionName"> Policy definition name. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="policyDefinitionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policyDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SummarizeResults>> SummarizeForPolicyDefinitionAsync(string subscriptionId, string policyDefinitionName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policyDefinitionName, nameof(policyDefinitionName));

            using var message = CreateSummarizeForPolicyDefinitionRequest(subscriptionId, policyDefinitionName, policyStateSummaryType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Summarizes policy states for the subscription level policy definition. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyDefinitionName"> Policy definition name. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="policyDefinitionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policyDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SummarizeResults> SummarizeForPolicyDefinition(string subscriptionId, string policyDefinitionName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policyDefinitionName, nameof(policyDefinitionName));

            using var message = CreateSummarizeForPolicyDefinitionRequest(subscriptionId, policyDefinitionName, policyStateSummaryType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForSubscriptionLevelPolicyAssignmentRequestUri(string subscriptionId, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policyAssignments/", false);
            uri.AppendPath(policyAssignmentName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForSubscriptionLevelPolicyAssignmentRequest(string subscriptionId, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policyAssignments/", false);
            uri.AppendPath(policyAssignmentName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the subscription level policy assignment. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="policyAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policyAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForSubscriptionLevelPolicyAssignmentAsync(string subscriptionId, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policyAssignmentName, nameof(policyAssignmentName));

            using var message = CreateListQueryResultsForSubscriptionLevelPolicyAssignmentRequest(subscriptionId, policyAssignmentName, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the subscription level policy assignment. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="policyAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policyAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForSubscriptionLevelPolicyAssignment(string subscriptionId, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policyAssignmentName, nameof(policyAssignmentName));

            using var message = CreateListQueryResultsForSubscriptionLevelPolicyAssignmentRequest(subscriptionId, policyAssignmentName, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateSummarizeForSubscriptionLevelPolicyAssignmentRequestUri(string subscriptionId, string policyAssignmentName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policyAssignments/", false);
            uri.AppendPath(policyAssignmentName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            return uri;
        }

        internal HttpMessage CreateSummarizeForSubscriptionLevelPolicyAssignmentRequest(string subscriptionId, string policyAssignmentName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policyAssignments/", false);
            uri.AppendPath(policyAssignmentName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Summarizes policy states for the subscription level policy assignment. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="policyAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policyAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SummarizeResults>> SummarizeForSubscriptionLevelPolicyAssignmentAsync(string subscriptionId, string policyAssignmentName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policyAssignmentName, nameof(policyAssignmentName));

            using var message = CreateSummarizeForSubscriptionLevelPolicyAssignmentRequest(subscriptionId, policyAssignmentName, policyStateSummaryType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Summarizes policy states for the subscription level policy assignment. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="policyAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policyAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SummarizeResults> SummarizeForSubscriptionLevelPolicyAssignment(string subscriptionId, string policyAssignmentName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policyAssignmentName, nameof(policyAssignmentName));

            using var message = CreateSummarizeForSubscriptionLevelPolicyAssignmentRequest(subscriptionId, policyAssignmentName, policyStateSummaryType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForResourceGroupLevelPolicyAssignmentRequestUri(string subscriptionId, string resourceGroupName, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourcegroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policyAssignments/", false);
            uri.AppendPath(policyAssignmentName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForResourceGroupLevelPolicyAssignmentRequest(string subscriptionId, string resourceGroupName, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourcegroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policyAssignments/", false);
            uri.AppendPath(policyAssignmentName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateType.ToString(), true);
            uri.AppendPath("/queryResults", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.OrderBy != null)
            {
                uri.AppendQuery("$orderby", policyQuerySettings.OrderBy, true);
            }
            if (policyQuerySettings?.Select != null)
            {
                uri.AppendQuery("$select", policyQuerySettings.Select, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            if (policyQuerySettings?.Apply != null)
            {
                uri.AppendQuery("$apply", policyQuerySettings.Apply, true);
            }
            if (policyQuerySettings?.SkipToken != null)
            {
                uri.AppendQuery("$skiptoken", policyQuerySettings.SkipToken, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the resource group level policy assignment. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="policyAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="policyAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForResourceGroupLevelPolicyAssignmentAsync(string subscriptionId, string resourceGroupName, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(policyAssignmentName, nameof(policyAssignmentName));

            using var message = CreateListQueryResultsForResourceGroupLevelPolicyAssignmentRequest(subscriptionId, resourceGroupName, policyAssignmentName, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the resource group level policy assignment. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="policyAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="policyAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForResourceGroupLevelPolicyAssignment(string subscriptionId, string resourceGroupName, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(policyAssignmentName, nameof(policyAssignmentName));

            using var message = CreateListQueryResultsForResourceGroupLevelPolicyAssignmentRequest(subscriptionId, resourceGroupName, policyAssignmentName, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateSummarizeForResourceGroupLevelPolicyAssignmentRequestUri(string subscriptionId, string resourceGroupName, string policyAssignmentName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourcegroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policyAssignments/", false);
            uri.AppendPath(policyAssignmentName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            return uri;
        }

        internal HttpMessage CreateSummarizeForResourceGroupLevelPolicyAssignmentRequest(string subscriptionId, string resourceGroupName, string policyAssignmentName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourcegroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/", false);
            uri.AppendPath("Microsoft.Authorization", true);
            uri.AppendPath("/policyAssignments/", false);
            uri.AppendPath(policyAssignmentName, true);
            uri.AppendPath("/providers/Microsoft.PolicyInsights/policyStates/", false);
            uri.AppendPath(policyStateSummaryType.ToString(), true);
            uri.AppendPath("/summarize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (policyQuerySettings?.Top != null)
            {
                uri.AppendQuery("$top", policyQuerySettings.Top.Value, true);
            }
            if (policyQuerySettings?.From != null)
            {
                uri.AppendQuery("$from", policyQuerySettings.From.Value, "O", true);
            }
            if (policyQuerySettings?.To != null)
            {
                uri.AppendQuery("$to", policyQuerySettings.To.Value, "O", true);
            }
            if (policyQuerySettings?.Filter != null)
            {
                uri.AppendQuery("$filter", policyQuerySettings.Filter, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Summarizes policy states for the resource group level policy assignment. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="policyAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="policyAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SummarizeResults>> SummarizeForResourceGroupLevelPolicyAssignmentAsync(string subscriptionId, string resourceGroupName, string policyAssignmentName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(policyAssignmentName, nameof(policyAssignmentName));

            using var message = CreateSummarizeForResourceGroupLevelPolicyAssignmentRequest(subscriptionId, resourceGroupName, policyAssignmentName, policyStateSummaryType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Summarizes policy states for the resource group level policy assignment. </summary>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyStateSummaryType"> The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="policyAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="policyAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SummarizeResults> SummarizeForResourceGroupLevelPolicyAssignment(string subscriptionId, string resourceGroupName, string policyAssignmentName, PolicyStateSummaryType policyStateSummaryType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(policyAssignmentName, nameof(policyAssignmentName));

            using var message = CreateSummarizeForResourceGroupLevelPolicyAssignmentRequest(subscriptionId, resourceGroupName, policyAssignmentName, policyStateSummaryType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SummarizeResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SummarizeResults.DeserializeSummarizeResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForManagementGroupNextPageRequestUri(string nextLink, string managementGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForManagementGroupNextPageRequest(string nextLink, string managementGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the resources under the management group. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="managementGroupName"> Management group name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="managementGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="managementGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForManagementGroupNextPageAsync(string nextLink, string managementGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(managementGroupName, nameof(managementGroupName));

            using var message = CreateListQueryResultsForManagementGroupNextPageRequest(nextLink, managementGroupName, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the resources under the management group. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="managementGroupName"> Management group name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="managementGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="managementGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForManagementGroupNextPage(string nextLink, string managementGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(managementGroupName, nameof(managementGroupName));

            using var message = CreateListQueryResultsForManagementGroupNextPageRequest(nextLink, managementGroupName, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForSubscriptionNextPageRequestUri(string nextLink, string subscriptionId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForSubscriptionNextPageRequest(string nextLink, string subscriptionId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the resources under the subscription. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForSubscriptionNextPageAsync(string nextLink, string subscriptionId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateListQueryResultsForSubscriptionNextPageRequest(nextLink, subscriptionId, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the resources under the subscription. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForSubscriptionNextPage(string nextLink, string subscriptionId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateListQueryResultsForSubscriptionNextPageRequest(nextLink, subscriptionId, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForResourceGroupNextPageRequestUri(string nextLink, string subscriptionId, string resourceGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForResourceGroupNextPageRequest(string nextLink, string subscriptionId, string resourceGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the resources under the resource group. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForResourceGroupNextPageAsync(string nextLink, string subscriptionId, string resourceGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));

            using var message = CreateListQueryResultsForResourceGroupNextPageRequest(nextLink, subscriptionId, resourceGroupName, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the resources under the resource group. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="resourceGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForResourceGroupNextPage(string nextLink, string subscriptionId, string resourceGroupName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));

            using var message = CreateListQueryResultsForResourceGroupNextPageRequest(nextLink, subscriptionId, resourceGroupName, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForResourceNextPageRequestUri(string nextLink, string resourceId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForResourceNextPageRequest(string nextLink, string resourceId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the resource. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="resourceId"/> is null. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForResourceNextPageAsync(string nextLink, string resourceId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNull(resourceId, nameof(resourceId));

            using var message = CreateListQueryResultsForResourceNextPageRequest(nextLink, resourceId, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the resource. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="resourceId"/> is null. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForResourceNextPage(string nextLink, string resourceId, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNull(resourceId, nameof(resourceId));

            using var message = CreateListQueryResultsForResourceNextPageRequest(nextLink, resourceId, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForPolicySetDefinitionNextPageRequestUri(string nextLink, string subscriptionId, string policySetDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForPolicySetDefinitionNextPageRequest(string nextLink, string subscriptionId, string policySetDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the subscription level policy set definition. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policySetDefinitionName"> Policy set definition name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/> or <paramref name="policySetDefinitionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policySetDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForPolicySetDefinitionNextPageAsync(string nextLink, string subscriptionId, string policySetDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policySetDefinitionName, nameof(policySetDefinitionName));

            using var message = CreateListQueryResultsForPolicySetDefinitionNextPageRequest(nextLink, subscriptionId, policySetDefinitionName, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the subscription level policy set definition. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policySetDefinitionName"> Policy set definition name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/> or <paramref name="policySetDefinitionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policySetDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForPolicySetDefinitionNextPage(string nextLink, string subscriptionId, string policySetDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policySetDefinitionName, nameof(policySetDefinitionName));

            using var message = CreateListQueryResultsForPolicySetDefinitionNextPageRequest(nextLink, subscriptionId, policySetDefinitionName, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForPolicyDefinitionNextPageRequestUri(string nextLink, string subscriptionId, string policyDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForPolicyDefinitionNextPageRequest(string nextLink, string subscriptionId, string policyDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the subscription level policy definition. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyDefinitionName"> Policy definition name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/> or <paramref name="policyDefinitionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policyDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForPolicyDefinitionNextPageAsync(string nextLink, string subscriptionId, string policyDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policyDefinitionName, nameof(policyDefinitionName));

            using var message = CreateListQueryResultsForPolicyDefinitionNextPageRequest(nextLink, subscriptionId, policyDefinitionName, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the subscription level policy definition. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyDefinitionName"> Policy definition name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/> or <paramref name="policyDefinitionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policyDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForPolicyDefinitionNextPage(string nextLink, string subscriptionId, string policyDefinitionName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policyDefinitionName, nameof(policyDefinitionName));

            using var message = CreateListQueryResultsForPolicyDefinitionNextPageRequest(nextLink, subscriptionId, policyDefinitionName, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForSubscriptionLevelPolicyAssignmentNextPageRequestUri(string nextLink, string subscriptionId, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForSubscriptionLevelPolicyAssignmentNextPageRequest(string nextLink, string subscriptionId, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the subscription level policy assignment. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/> or <paramref name="policyAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policyAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForSubscriptionLevelPolicyAssignmentNextPageAsync(string nextLink, string subscriptionId, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policyAssignmentName, nameof(policyAssignmentName));

            using var message = CreateListQueryResultsForSubscriptionLevelPolicyAssignmentNextPageRequest(nextLink, subscriptionId, policyAssignmentName, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the subscription level policy assignment. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/> or <paramref name="policyAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="policyAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForSubscriptionLevelPolicyAssignmentNextPage(string nextLink, string subscriptionId, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(policyAssignmentName, nameof(policyAssignmentName));

            using var message = CreateListQueryResultsForSubscriptionLevelPolicyAssignmentNextPageRequest(nextLink, subscriptionId, policyAssignmentName, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListQueryResultsForResourceGroupLevelPolicyAssignmentNextPageRequestUri(string nextLink, string subscriptionId, string resourceGroupName, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListQueryResultsForResourceGroupLevelPolicyAssignmentNextPageRequest(string nextLink, string subscriptionId, string resourceGroupName, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Queries policy states for the resource group level policy assignment. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="policyAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="policyAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PolicyStatesQueryResults>> ListQueryResultsForResourceGroupLevelPolicyAssignmentNextPageAsync(string nextLink, string subscriptionId, string resourceGroupName, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(policyAssignmentName, nameof(policyAssignmentName));

            using var message = CreateListQueryResultsForResourceGroupLevelPolicyAssignmentNextPageRequest(nextLink, subscriptionId, resourceGroupName, policyAssignmentName, policyStateType, policyQuerySettings);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Queries policy states for the resource group level policy assignment. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Microsoft Azure subscription ID. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyStateType"> The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s). </param>
        /// <param name="policyQuerySettings"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="policyAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="policyAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PolicyStatesQueryResults> ListQueryResultsForResourceGroupLevelPolicyAssignmentNextPage(string nextLink, string subscriptionId, string resourceGroupName, string policyAssignmentName, PolicyStateType policyStateType, PolicyQuerySettings policyQuerySettings = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(policyAssignmentName, nameof(policyAssignmentName));

            using var message = CreateListQueryResultsForResourceGroupLevelPolicyAssignmentNextPageRequest(nextLink, subscriptionId, resourceGroupName, policyAssignmentName, policyStateType, policyQuerySettings);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyStatesQueryResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyStatesQueryResults.DeserializePolicyStatesQueryResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
