// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PolicyInsights.Models
{
    /// <summary> The deployment status summary for all deployments created by the remediation. </summary>
    public partial class RemediationDeploymentSummary
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RemediationDeploymentSummary"/>. </summary>
        internal RemediationDeploymentSummary()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RemediationDeploymentSummary"/>. </summary>
        /// <param name="totalDeployments"> The number of deployments required by the remediation. </param>
        /// <param name="successfulDeployments"> The number of deployments required by the remediation that have succeeded. </param>
        /// <param name="failedDeployments"> The number of deployments required by the remediation that have failed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RemediationDeploymentSummary(int? totalDeployments, int? successfulDeployments, int? failedDeployments, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TotalDeployments = totalDeployments;
            SuccessfulDeployments = successfulDeployments;
            FailedDeployments = failedDeployments;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The number of deployments required by the remediation. </summary>
        public int? TotalDeployments { get; }
        /// <summary> The number of deployments required by the remediation that have succeeded. </summary>
        public int? SuccessfulDeployments { get; }
        /// <summary> The number of deployments required by the remediation that have failed. </summary>
        public int? FailedDeployments { get; }
    }
}
