// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PolicyInsights.Models
{
    /// <summary> The PolicyTrackedResourceType. </summary>
    public readonly partial struct PolicyTrackedResourceType : IEquatable<PolicyTrackedResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PolicyTrackedResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PolicyTrackedResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "default";

        /// <summary> default. </summary>
        public static PolicyTrackedResourceType Default { get; } = new PolicyTrackedResourceType(DefaultValue);
        /// <summary> Determines if two <see cref="PolicyTrackedResourceType"/> values are the same. </summary>
        public static bool operator ==(PolicyTrackedResourceType left, PolicyTrackedResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PolicyTrackedResourceType"/> values are not the same. </summary>
        public static bool operator !=(PolicyTrackedResourceType left, PolicyTrackedResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PolicyTrackedResourceType"/>. </summary>
        public static implicit operator PolicyTrackedResourceType(string value) => new PolicyTrackedResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PolicyTrackedResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PolicyTrackedResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
