// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.PolicyInsights.Models
{
    public partial class PolicySummaryResults : IUtf8JsonSerializable, IJsonModel<PolicySummaryResults>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PolicySummaryResults>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PolicySummaryResults>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PolicySummaryResults>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PolicySummaryResults)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(QueryResultsUri))
            {
                writer.WritePropertyName("queryResultsUri"u8);
                writer.WriteStringValue(QueryResultsUri.AbsoluteUri);
            }
            if (Optional.IsDefined(NonCompliantResources))
            {
                writer.WritePropertyName("nonCompliantResources"u8);
                writer.WriteNumberValue(NonCompliantResources.Value);
            }
            if (Optional.IsDefined(NonCompliantPolicies))
            {
                writer.WritePropertyName("nonCompliantPolicies"u8);
                writer.WriteNumberValue(NonCompliantPolicies.Value);
            }
            if (Optional.IsCollectionDefined(ResourceDetails))
            {
                writer.WritePropertyName("resourceDetails"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(PolicyDetails))
            {
                writer.WritePropertyName("policyDetails"u8);
                writer.WriteStartArray();
                foreach (var item in PolicyDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(PolicyGroupDetails))
            {
                writer.WritePropertyName("policyGroupDetails"u8);
                writer.WriteStartArray();
                foreach (var item in PolicyGroupDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PolicySummaryResults IJsonModel<PolicySummaryResults>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PolicySummaryResults>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PolicySummaryResults)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePolicySummaryResults(document.RootElement, options);
        }

        internal static PolicySummaryResults DeserializePolicySummaryResults(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Uri queryResultsUri = default;
            int? nonCompliantResources = default;
            int? nonCompliantPolicies = default;
            IReadOnlyList<ComplianceDetail> resourceDetails = default;
            IReadOnlyList<ComplianceDetail> policyDetails = default;
            IReadOnlyList<ComplianceDetail> policyGroupDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("queryResultsUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    queryResultsUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("nonCompliantResources"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nonCompliantResources = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("nonCompliantPolicies"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nonCompliantPolicies = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("resourceDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ComplianceDetail> array = new List<ComplianceDetail>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ComplianceDetail.DeserializeComplianceDetail(item, options));
                    }
                    resourceDetails = array;
                    continue;
                }
                if (property.NameEquals("policyDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ComplianceDetail> array = new List<ComplianceDetail>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ComplianceDetail.DeserializeComplianceDetail(item, options));
                    }
                    policyDetails = array;
                    continue;
                }
                if (property.NameEquals("policyGroupDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ComplianceDetail> array = new List<ComplianceDetail>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ComplianceDetail.DeserializeComplianceDetail(item, options));
                    }
                    policyGroupDetails = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PolicySummaryResults(
                queryResultsUri,
                nonCompliantResources,
                nonCompliantPolicies,
                resourceDetails ?? new ChangeTrackingList<ComplianceDetail>(),
                policyDetails ?? new ChangeTrackingList<ComplianceDetail>(),
                policyGroupDetails ?? new ChangeTrackingList<ComplianceDetail>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PolicySummaryResults>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PolicySummaryResults>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PolicySummaryResults)} does not support writing '{options.Format}' format.");
            }
        }

        PolicySummaryResults IPersistableModel<PolicySummaryResults>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PolicySummaryResults>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePolicySummaryResults(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PolicySummaryResults)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PolicySummaryResults>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
