// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PolicyInsights.Models
{
    /// <summary> Summary results. </summary>
    public partial class PolicySummary
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PolicySummary"/>. </summary>
        internal PolicySummary()
        {
            PolicyAssignments = new ChangeTrackingList<PolicyAssignmentSummary>();
        }

        /// <summary> Initializes a new instance of <see cref="PolicySummary"/>. </summary>
        /// <param name="odataId"> OData entity ID; always set to null since summaries do not have an entity ID. </param>
        /// <param name="odataContext"> OData context string; used by OData clients to resolve type information based on metadata. </param>
        /// <param name="results"> Compliance summary for all policy assignments. </param>
        /// <param name="policyAssignments"> Policy assignments summary. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PolicySummary(string odataId, string odataContext, PolicySummaryResults results, IReadOnlyList<PolicyAssignmentSummary> policyAssignments, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ODataId = odataId;
            ODataContext = odataContext;
            Results = results;
            PolicyAssignments = policyAssignments;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> OData entity ID; always set to null since summaries do not have an entity ID. </summary>
        public string ODataId { get; }
        /// <summary> OData context string; used by OData clients to resolve type information based on metadata. </summary>
        public string ODataContext { get; }
        /// <summary> Compliance summary for all policy assignments. </summary>
        public PolicySummaryResults Results { get; }
        /// <summary> Policy assignments summary. </summary>
        public IReadOnlyList<PolicyAssignmentSummary> PolicyAssignments { get; }
    }
}
