// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PolicyInsights.Models
{
    /// <summary> The PolicyStateType. </summary>
    public readonly partial struct PolicyStateType : IEquatable<PolicyStateType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PolicyStateType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PolicyStateType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "default";
        private const string LatestValue = "latest";

        /// <summary> default. </summary>
        public static PolicyStateType Default { get; } = new PolicyStateType(DefaultValue);
        /// <summary> latest. </summary>
        public static PolicyStateType Latest { get; } = new PolicyStateType(LatestValue);
        /// <summary> Determines if two <see cref="PolicyStateType"/> values are the same. </summary>
        public static bool operator ==(PolicyStateType left, PolicyStateType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PolicyStateType"/> values are not the same. </summary>
        public static bool operator !=(PolicyStateType left, PolicyStateType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PolicyStateType"/>. </summary>
        public static implicit operator PolicyStateType(string value) => new PolicyStateType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PolicyStateType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PolicyStateType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
