// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PolicyInsights.Models
{
    /// <summary> The PolicyStateSummaryType. </summary>
    public readonly partial struct PolicyStateSummaryType : IEquatable<PolicyStateSummaryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PolicyStateSummaryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PolicyStateSummaryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LatestValue = "latest";

        /// <summary> latest. </summary>
        public static PolicyStateSummaryType Latest { get; } = new PolicyStateSummaryType(LatestValue);
        /// <summary> Determines if two <see cref="PolicyStateSummaryType"/> values are the same. </summary>
        public static bool operator ==(PolicyStateSummaryType left, PolicyStateSummaryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PolicyStateSummaryType"/> values are not the same. </summary>
        public static bool operator !=(PolicyStateSummaryType left, PolicyStateSummaryType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PolicyStateSummaryType"/>. </summary>
        public static implicit operator PolicyStateSummaryType(string value) => new PolicyStateSummaryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PolicyStateSummaryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PolicyStateSummaryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
