// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.PolicyInsights.Models
{
    /// <summary> Resource identifiers for a policy. </summary>
    public partial class PolicyReference
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PolicyReference"/>. </summary>
        internal PolicyReference()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PolicyReference"/>. </summary>
        /// <param name="policyDefinitionId"> The resource identifier of the policy definition. </param>
        /// <param name="policySetDefinitionId"> The resource identifier of the policy set definition. </param>
        /// <param name="policyDefinitionReferenceId"> The reference identifier of a specific policy definition within a policy set definition. </param>
        /// <param name="policyAssignmentId"> The resource identifier of the policy assignment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PolicyReference(ResourceIdentifier policyDefinitionId, ResourceIdentifier policySetDefinitionId, string policyDefinitionReferenceId, ResourceIdentifier policyAssignmentId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PolicyDefinitionId = policyDefinitionId;
            PolicySetDefinitionId = policySetDefinitionId;
            PolicyDefinitionReferenceId = policyDefinitionReferenceId;
            PolicyAssignmentId = policyAssignmentId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The resource identifier of the policy definition. </summary>
        public ResourceIdentifier PolicyDefinitionId { get; }
        /// <summary> The resource identifier of the policy set definition. </summary>
        public ResourceIdentifier PolicySetDefinitionId { get; }
        /// <summary> The reference identifier of a specific policy definition within a policy set definition. </summary>
        public string PolicyDefinitionReferenceId { get; }
        /// <summary> The resource identifier of the policy assignment. </summary>
        public ResourceIdentifier PolicyAssignmentId { get; }
    }
}
