// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PolicyInsights.Models
{
    /// <summary> The PolicyEventType. </summary>
    public readonly partial struct PolicyEventType : IEquatable<PolicyEventType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PolicyEventType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PolicyEventType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "default";

        /// <summary> default. </summary>
        public static PolicyEventType Default { get; } = new PolicyEventType(DefaultValue);
        /// <summary> Determines if two <see cref="PolicyEventType"/> values are the same. </summary>
        public static bool operator ==(PolicyEventType left, PolicyEventType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PolicyEventType"/> values are not the same. </summary>
        public static bool operator !=(PolicyEventType left, PolicyEventType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PolicyEventType"/>. </summary>
        public static implicit operator PolicyEventType(string value) => new PolicyEventType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PolicyEventType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PolicyEventType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
