// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.PolicyInsights.Models
{
    /// <summary> Policy assignment summary. </summary>
    public partial class PolicyAssignmentSummary
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PolicyAssignmentSummary"/>. </summary>
        internal PolicyAssignmentSummary()
        {
            PolicyDefinitions = new ChangeTrackingList<PolicyDefinitionSummary>();
            PolicyGroups = new ChangeTrackingList<PolicyGroupSummary>();
        }

        /// <summary> Initializes a new instance of <see cref="PolicyAssignmentSummary"/>. </summary>
        /// <param name="policyAssignmentId"> Policy assignment ID. </param>
        /// <param name="policySetDefinitionId"> Policy set definition ID, if the policy assignment is for a policy set. </param>
        /// <param name="results"> Compliance summary for the policy assignment. </param>
        /// <param name="policyDefinitions"> Policy definitions summary. </param>
        /// <param name="policyGroups"> Policy definition group summary. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PolicyAssignmentSummary(ResourceIdentifier policyAssignmentId, ResourceIdentifier policySetDefinitionId, PolicySummaryResults results, IReadOnlyList<PolicyDefinitionSummary> policyDefinitions, IReadOnlyList<PolicyGroupSummary> policyGroups, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PolicyAssignmentId = policyAssignmentId;
            PolicySetDefinitionId = policySetDefinitionId;
            Results = results;
            PolicyDefinitions = policyDefinitions;
            PolicyGroups = policyGroups;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Policy assignment ID. </summary>
        public ResourceIdentifier PolicyAssignmentId { get; }
        /// <summary> Policy set definition ID, if the policy assignment is for a policy set. </summary>
        public ResourceIdentifier PolicySetDefinitionId { get; }
        /// <summary> Compliance summary for the policy assignment. </summary>
        public PolicySummaryResults Results { get; }
        /// <summary> Policy definitions summary. </summary>
        public IReadOnlyList<PolicyDefinitionSummary> PolicyDefinitions { get; }
        /// <summary> Policy definition group summary. </summary>
        public IReadOnlyList<PolicyGroupSummary> PolicyGroups { get; }
    }
}
