// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.PolicyInsights.Models
{
    /// <summary> Evaluation details of IfNotExists effect. </summary>
    public partial class IfNotExistsEvaluationDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IfNotExistsEvaluationDetails"/>. </summary>
        internal IfNotExistsEvaluationDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IfNotExistsEvaluationDetails"/>. </summary>
        /// <param name="resourceId"> ID of the last evaluated resource for IfNotExists effect. </param>
        /// <param name="totalResources"> Total number of resources to which the existence condition is applicable. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IfNotExistsEvaluationDetails(ResourceIdentifier resourceId, int? totalResources, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceId = resourceId;
            TotalResources = totalResources;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> ID of the last evaluated resource for IfNotExists effect. </summary>
        public ResourceIdentifier ResourceId { get; }
        /// <summary> Total number of resources to which the existence condition is applicable. </summary>
        public int? TotalResources { get; }
    }
}
