// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.PolicyInsights.Models
{
    public partial class CheckPolicyRestrictionsContent : IUtf8JsonSerializable, IJsonModel<CheckPolicyRestrictionsContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CheckPolicyRestrictionsContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CheckPolicyRestrictionsContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CheckPolicyRestrictionsContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CheckPolicyRestrictionsContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("resourceDetails"u8);
            writer.WriteObjectValue(ResourceDetails, options);
            if (Optional.IsCollectionDefined(PendingFields))
            {
                writer.WritePropertyName("pendingFields"u8);
                writer.WriteStartArray();
                foreach (var item in PendingFields)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CheckPolicyRestrictionsContent IJsonModel<CheckPolicyRestrictionsContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CheckPolicyRestrictionsContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CheckPolicyRestrictionsContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCheckPolicyRestrictionsContent(document.RootElement, options);
        }

        internal static CheckPolicyRestrictionsContent DeserializeCheckPolicyRestrictionsContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            CheckRestrictionsResourceDetails resourceDetails = default;
            IList<PendingField> pendingFields = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("resourceDetails"u8))
                {
                    resourceDetails = CheckRestrictionsResourceDetails.DeserializeCheckRestrictionsResourceDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("pendingFields"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<PendingField> array = new List<PendingField>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(PendingField.DeserializePendingField(item, options));
                    }
                    pendingFields = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CheckPolicyRestrictionsContent(resourceDetails, pendingFields ?? new ChangeTrackingList<PendingField>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CheckPolicyRestrictionsContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CheckPolicyRestrictionsContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CheckPolicyRestrictionsContent)} does not support writing '{options.Format}' format.");
            }
        }

        CheckPolicyRestrictionsContent IPersistableModel<CheckPolicyRestrictionsContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CheckPolicyRestrictionsContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCheckPolicyRestrictionsContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CheckPolicyRestrictionsContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CheckPolicyRestrictionsContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
