// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PolicyInsights
{
    internal class PolicyAttestationOperationSource : IOperationSource<PolicyAttestationResource>
    {
        private readonly ArmClient _client;

        internal PolicyAttestationOperationSource(ArmClient client)
        {
            _client = client;
        }

        PolicyAttestationResource IOperationSource<PolicyAttestationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PolicyAttestationData.DeserializePolicyAttestationData(document.RootElement);
            return new PolicyAttestationResource(_client, data);
        }

        async ValueTask<PolicyAttestationResource> IOperationSource<PolicyAttestationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PolicyAttestationData.DeserializePolicyAttestationData(document.RootElement);
            return new PolicyAttestationResource(_client, data);
        }
    }
}
