// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.PolicyInsights.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmPolicyInsightsModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.PolicyTrackedResourceRecord"/>. </summary>
        /// <param name="trackedResourceId"> The ID of the policy tracked resource. </param>
        /// <param name="policyDetails"> The details of the policy that require the tracked resource. </param>
        /// <param name="createdBy"> The details of the policy triggered deployment that created the tracked resource. </param>
        /// <param name="lastModifiedBy"> The details of the policy triggered deployment that modified the tracked resource. </param>
        /// <param name="lastUpdateOn"> Timestamp of the last update to the tracked resource. </param>
        /// <returns> A new <see cref="Models.PolicyTrackedResourceRecord"/> instance for mocking. </returns>
        public static PolicyTrackedResourceRecord PolicyTrackedResourceRecord(ResourceIdentifier trackedResourceId = null, PolicyDetails policyDetails = null, TrackedResourceModificationDetails createdBy = null, TrackedResourceModificationDetails lastModifiedBy = null, DateTimeOffset? lastUpdateOn = null)
        {
            return new PolicyTrackedResourceRecord(
                trackedResourceId,
                policyDetails,
                createdBy,
                lastModifiedBy,
                lastUpdateOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PolicyDetails"/>. </summary>
        /// <param name="policyDefinitionId"> The ID of the policy definition. </param>
        /// <param name="policyAssignmentId"> The ID of the policy assignment. </param>
        /// <param name="policyAssignmentDisplayName"> The display name of the policy assignment. </param>
        /// <param name="policyAssignmentScope"> The scope of the policy assignment. </param>
        /// <param name="policySetDefinitionId"> The ID of the policy set definition. </param>
        /// <param name="policyDefinitionReferenceId"> The policy definition reference ID within the policy set definition. </param>
        /// <returns> A new <see cref="Models.PolicyDetails"/> instance for mocking. </returns>
        public static PolicyDetails PolicyDetails(ResourceIdentifier policyDefinitionId = null, ResourceIdentifier policyAssignmentId = null, string policyAssignmentDisplayName = null, string policyAssignmentScope = null, ResourceIdentifier policySetDefinitionId = null, string policyDefinitionReferenceId = null)
        {
            return new PolicyDetails(
                policyDefinitionId,
                policyAssignmentId,
                policyAssignmentDisplayName,
                policyAssignmentScope,
                policySetDefinitionId,
                policyDefinitionReferenceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TrackedResourceModificationDetails"/>. </summary>
        /// <param name="policyDetails"> The details of the policy that created or modified the tracked resource. </param>
        /// <param name="deploymentId"> The ID of the deployment that created or modified the tracked resource. </param>
        /// <param name="deploymentOn"> Timestamp of the deployment that created or modified the tracked resource. </param>
        /// <returns> A new <see cref="Models.TrackedResourceModificationDetails"/> instance for mocking. </returns>
        public static TrackedResourceModificationDetails TrackedResourceModificationDetails(PolicyDetails policyDetails = null, ResourceIdentifier deploymentId = null, DateTimeOffset? deploymentOn = null)
        {
            return new TrackedResourceModificationDetails(policyDetails, deploymentId, deploymentOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RemediationDeployment"/>. </summary>
        /// <param name="remediatedResourceId"> Resource ID of the resource that is being remediated by the deployment. </param>
        /// <param name="deploymentId"> Resource ID of the template deployment that will remediate the resource. </param>
        /// <param name="status"> Status of the remediation deployment. </param>
        /// <param name="resourceLocation"> Location of the resource that is being remediated. </param>
        /// <param name="error"> Error encountered while remediated the resource. </param>
        /// <param name="createdOn"> The time at which the remediation was created. </param>
        /// <param name="lastUpdatedOn"> The time at which the remediation deployment was last updated. </param>
        /// <returns> A new <see cref="Models.RemediationDeployment"/> instance for mocking. </returns>
        public static RemediationDeployment RemediationDeployment(ResourceIdentifier remediatedResourceId = null, ResourceIdentifier deploymentId = null, string status = null, AzureLocation? resourceLocation = null, ResponseError error = null, DateTimeOffset? createdOn = null, DateTimeOffset? lastUpdatedOn = null)
        {
            return new RemediationDeployment(
                remediatedResourceId,
                deploymentId,
                status,
                resourceLocation,
                error,
                createdOn,
                lastUpdatedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="PolicyInsights.PolicyRemediationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="policyAssignmentId"> The resource ID of the policy assignment that should be remediated. </param>
        /// <param name="policyDefinitionReferenceId"> The policy definition reference ID of the individual definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition. </param>
        /// <param name="resourceDiscoveryMode"> The way resources to remediate are discovered. Defaults to ExistingNonCompliant if not specified. </param>
        /// <param name="provisioningState"> The status of the remediation. </param>
        /// <param name="createdOn"> The time at which the remediation was created. </param>
        /// <param name="lastUpdatedOn"> The time at which the remediation was last updated. </param>
        /// <param name="filterLocations"> The filters that will be applied to determine which resources to remediate. </param>
        /// <param name="deploymentStatus"> The deployment status summary for all deployments created by the remediation. </param>
        /// <param name="statusMessage"> The remediation status message. Provides additional details regarding the state of the remediation. </param>
        /// <param name="correlationId"> The remediation correlation Id. Can be used to find events related to the remediation in the activity log. </param>
        /// <param name="resourceCount"> Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used. </param>
        /// <param name="parallelDeployments"> Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used. </param>
        /// <param name="failureThresholdPercentage"> The remediation failure threshold settings. </param>
        /// <returns> A new <see cref="PolicyInsights.PolicyRemediationData"/> instance for mocking. </returns>
        public static PolicyRemediationData PolicyRemediationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier policyAssignmentId = null, string policyDefinitionReferenceId = null, ResourceDiscoveryMode? resourceDiscoveryMode = null, string provisioningState = null, DateTimeOffset? createdOn = null, DateTimeOffset? lastUpdatedOn = null, IEnumerable<AzureLocation> filterLocations = null, RemediationDeploymentSummary deploymentStatus = null, string statusMessage = null, string correlationId = null, int? resourceCount = null, int? parallelDeployments = null, float? failureThresholdPercentage = null)
        {
            filterLocations ??= new List<AzureLocation>();

            return new PolicyRemediationData(
                id,
                name,
                resourceType,
                systemData,
                policyAssignmentId,
                policyDefinitionReferenceId,
                resourceDiscoveryMode,
                provisioningState,
                createdOn,
                lastUpdatedOn,
                filterLocations != null ? new RemediationFilters(filterLocations?.ToList(), serializedAdditionalRawData: null) : null,
                deploymentStatus,
                statusMessage,
                correlationId,
                resourceCount,
                parallelDeployments,
                failureThresholdPercentage != null ? new RemediationPropertiesFailureThreshold(failureThresholdPercentage, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RemediationDeploymentSummary"/>. </summary>
        /// <param name="totalDeployments"> The number of deployments required by the remediation. </param>
        /// <param name="successfulDeployments"> The number of deployments required by the remediation that have succeeded. </param>
        /// <param name="failedDeployments"> The number of deployments required by the remediation that have failed. </param>
        /// <returns> A new <see cref="Models.RemediationDeploymentSummary"/> instance for mocking. </returns>
        public static RemediationDeploymentSummary RemediationDeploymentSummary(int? totalDeployments = null, int? successfulDeployments = null, int? failedDeployments = null)
        {
            return new RemediationDeploymentSummary(totalDeployments, successfulDeployments, failedDeployments, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PolicyEvent"/>. </summary>
        /// <param name="odataId"> OData entity ID; always set to null since policy event records do not have an entity ID. </param>
        /// <param name="odataContext"> OData context string; used by OData clients to resolve type information based on metadata. </param>
        /// <param name="timestamp"> Timestamp for the policy event record. </param>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="policyAssignmentId"> Policy assignment ID. </param>
        /// <param name="policyDefinitionId"> Policy definition ID. </param>
        /// <param name="effectiveParameters"> Effective parameters for the policy assignment. </param>
        /// <param name="isCompliant"> Flag which states whether the resource is compliant against the policy assignment it was evaluated against. </param>
        /// <param name="subscriptionId"> Subscription ID. </param>
        /// <param name="resourceTypeString"> Resource type. </param>
        /// <param name="resourceLocation"> Resource location. </param>
        /// <param name="resourceGroup"> Resource group name. </param>
        /// <param name="resourceTags"> List of resource tags. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyAssignmentOwner"> Policy assignment owner. </param>
        /// <param name="policyAssignmentParameters"> Policy assignment parameters. </param>
        /// <param name="policyAssignmentScope"> Policy assignment scope. </param>
        /// <param name="policyDefinitionName"> Policy definition name. </param>
        /// <param name="policyDefinitionAction"> Policy definition action, i.e. effect. </param>
        /// <param name="policyDefinitionCategory"> Policy definition category. </param>
        /// <param name="policySetDefinitionId"> Policy set definition ID, if the policy assignment is for a policy set. </param>
        /// <param name="policySetDefinitionName"> Policy set definition name, if the policy assignment is for a policy set. </param>
        /// <param name="policySetDefinitionOwner"> Policy set definition owner, if the policy assignment is for a policy set. </param>
        /// <param name="policySetDefinitionCategory"> Policy set definition category, if the policy assignment is for a policy set. </param>
        /// <param name="policySetDefinitionParameters"> Policy set definition parameters, if the policy assignment is for a policy set. </param>
        /// <param name="managementGroupIds"> Comma separated list of management group IDs, which represent the hierarchy of the management groups the resource is under. </param>
        /// <param name="policyDefinitionReferenceId"> Reference ID for the policy definition inside the policy set, if the policy assignment is for a policy set. </param>
        /// <param name="complianceState"> Compliance state of the resource. </param>
        /// <param name="tenantId"> Tenant ID for the policy event record. </param>
        /// <param name="principalOid"> Principal object ID for the user who initiated the resource operation that triggered the policy event. </param>
        /// <param name="components"> Components events records populated only when URL contains $expand=components clause. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.PolicyEvent"/> instance for mocking. </returns>
        public static PolicyEvent PolicyEvent(string odataId = null, string odataContext = null, DateTimeOffset? timestamp = null, ResourceIdentifier resourceId = null, ResourceIdentifier policyAssignmentId = null, ResourceIdentifier policyDefinitionId = null, string effectiveParameters = null, bool? isCompliant = null, string subscriptionId = null, string resourceTypeString = null, AzureLocation? resourceLocation = null, string resourceGroup = null, string resourceTags = null, string policyAssignmentName = null, string policyAssignmentOwner = null, string policyAssignmentParameters = null, string policyAssignmentScope = null, string policyDefinitionName = null, string policyDefinitionAction = null, string policyDefinitionCategory = null, ResourceIdentifier policySetDefinitionId = null, string policySetDefinitionName = null, string policySetDefinitionOwner = null, string policySetDefinitionCategory = null, string policySetDefinitionParameters = null, string managementGroupIds = null, string policyDefinitionReferenceId = null, string complianceState = null, Guid? tenantId = null, string principalOid = null, IEnumerable<ComponentEventDetails> components = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            components ??= new List<ComponentEventDetails>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new PolicyEvent(
                odataId,
                odataContext,
                timestamp,
                resourceId,
                policyAssignmentId,
                policyDefinitionId,
                effectiveParameters,
                isCompliant,
                subscriptionId,
                resourceTypeString,
                resourceLocation,
                resourceGroup,
                resourceTags,
                policyAssignmentName,
                policyAssignmentOwner,
                policyAssignmentParameters,
                policyAssignmentScope,
                policyDefinitionName,
                policyDefinitionAction,
                policyDefinitionCategory,
                policySetDefinitionId,
                policySetDefinitionName,
                policySetDefinitionOwner,
                policySetDefinitionCategory,
                policySetDefinitionParameters,
                managementGroupIds,
                policyDefinitionReferenceId,
                complianceState,
                tenantId,
                principalOid,
                components?.ToList(),
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ComponentEventDetails"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="timestamp"> Timestamp for component policy event record. </param>
        /// <param name="tenantId"> Tenant ID for the policy event record. </param>
        /// <param name="principalOid"> Principal object ID for the user who initiated the resource component operation that triggered the policy event. </param>
        /// <param name="policyDefinitionAction"> Policy definition action, i.e. effect. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.ComponentEventDetails"/> instance for mocking. </returns>
        public static ComponentEventDetails ComponentEventDetails(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? timestamp = null, Guid? tenantId = null, string principalOid = null, string policyDefinitionAction = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new ComponentEventDetails(
                id,
                name,
                resourceType,
                systemData,
                timestamp,
                tenantId,
                principalOid,
                policyDefinitionAction,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PolicyState"/>. </summary>
        /// <param name="odataId"> OData entity ID; always set to null since policy state records do not have an entity ID. </param>
        /// <param name="odataContext"> OData context string; used by OData clients to resolve type information based on metadata. </param>
        /// <param name="timestamp"> Timestamp for the policy state record. </param>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="policyAssignmentId"> Policy assignment ID. </param>
        /// <param name="policyDefinitionId"> Policy definition ID. </param>
        /// <param name="effectiveParameters"> Effective parameters for the policy assignment. </param>
        /// <param name="isCompliant"> Flag which states whether the resource is compliant against the policy assignment it was evaluated against. This property is deprecated; please use ComplianceState instead. </param>
        /// <param name="subscriptionId"> Subscription ID. </param>
        /// <param name="resourceTypeString"> Resource type. </param>
        /// <param name="resourceLocation"> Resource location. </param>
        /// <param name="resourceGroup"> Resource group name. </param>
        /// <param name="resourceTags"> List of resource tags. </param>
        /// <param name="policyAssignmentName"> Policy assignment name. </param>
        /// <param name="policyAssignmentOwner"> Policy assignment owner. </param>
        /// <param name="policyAssignmentParameters"> Policy assignment parameters. </param>
        /// <param name="policyAssignmentScope"> Policy assignment scope. </param>
        /// <param name="policyDefinitionName"> Policy definition name. </param>
        /// <param name="policyDefinitionAction"> Policy definition action, i.e. effect. </param>
        /// <param name="policyDefinitionCategory"> Policy definition category. </param>
        /// <param name="policySetDefinitionId"> Policy set definition ID, if the policy assignment is for a policy set. </param>
        /// <param name="policySetDefinitionName"> Policy set definition name, if the policy assignment is for a policy set. </param>
        /// <param name="policySetDefinitionOwner"> Policy set definition owner, if the policy assignment is for a policy set. </param>
        /// <param name="policySetDefinitionCategory"> Policy set definition category, if the policy assignment is for a policy set. </param>
        /// <param name="policySetDefinitionParameters"> Policy set definition parameters, if the policy assignment is for a policy set. </param>
        /// <param name="managementGroupIds"> Comma separated list of management group IDs, which represent the hierarchy of the management groups the resource is under. </param>
        /// <param name="policyDefinitionReferenceId"> Reference ID for the policy definition inside the policy set, if the policy assignment is for a policy set. </param>
        /// <param name="complianceState"> Compliance state of the resource. </param>
        /// <param name="policyEvaluationDetails"> Policy evaluation details. </param>
        /// <param name="policyDefinitionGroupNames"> Policy definition group names. </param>
        /// <param name="components"> Components state compliance records populated only when URL contains $expand=components clause. </param>
        /// <param name="policyDefinitionVersion"> Evaluated policy definition version. </param>
        /// <param name="policySetDefinitionVersion"> Evaluated policy set definition version. </param>
        /// <param name="policyAssignmentVersion"> Evaluated policy assignment version. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.PolicyState"/> instance for mocking. </returns>
        public static PolicyState PolicyState(string odataId = null, string odataContext = null, DateTimeOffset? timestamp = null, ResourceIdentifier resourceId = null, ResourceIdentifier policyAssignmentId = null, ResourceIdentifier policyDefinitionId = null, string effectiveParameters = null, bool? isCompliant = null, string subscriptionId = null, string resourceTypeString = null, AzureLocation? resourceLocation = null, string resourceGroup = null, string resourceTags = null, string policyAssignmentName = null, string policyAssignmentOwner = null, string policyAssignmentParameters = null, string policyAssignmentScope = null, string policyDefinitionName = null, string policyDefinitionAction = null, string policyDefinitionCategory = null, ResourceIdentifier policySetDefinitionId = null, string policySetDefinitionName = null, string policySetDefinitionOwner = null, string policySetDefinitionCategory = null, string policySetDefinitionParameters = null, string managementGroupIds = null, string policyDefinitionReferenceId = null, string complianceState = null, PolicyEvaluationDetails policyEvaluationDetails = null, IEnumerable<string> policyDefinitionGroupNames = null, IEnumerable<ComponentStateDetails> components = null, string policyDefinitionVersion = null, string policySetDefinitionVersion = null, string policyAssignmentVersion = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            policyDefinitionGroupNames ??= new List<string>();
            components ??= new List<ComponentStateDetails>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new PolicyState(
                odataId,
                odataContext,
                timestamp,
                resourceId,
                policyAssignmentId,
                policyDefinitionId,
                effectiveParameters,
                isCompliant,
                subscriptionId,
                resourceTypeString,
                resourceLocation,
                resourceGroup,
                resourceTags,
                policyAssignmentName,
                policyAssignmentOwner,
                policyAssignmentParameters,
                policyAssignmentScope,
                policyDefinitionName,
                policyDefinitionAction,
                policyDefinitionCategory,
                policySetDefinitionId,
                policySetDefinitionName,
                policySetDefinitionOwner,
                policySetDefinitionCategory,
                policySetDefinitionParameters,
                managementGroupIds,
                policyDefinitionReferenceId,
                complianceState,
                policyEvaluationDetails,
                policyDefinitionGroupNames?.ToList(),
                components?.ToList(),
                policyDefinitionVersion,
                policySetDefinitionVersion,
                policyAssignmentVersion,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PolicyEvaluationDetails"/>. </summary>
        /// <param name="evaluatedExpressions"> Details of the evaluated expressions. </param>
        /// <param name="ifNotExistsDetails"> Evaluation details of IfNotExists effect. </param>
        /// <returns> A new <see cref="Models.PolicyEvaluationDetails"/> instance for mocking. </returns>
        public static PolicyEvaluationDetails PolicyEvaluationDetails(IEnumerable<ExpressionEvaluationDetails> evaluatedExpressions = null, IfNotExistsEvaluationDetails ifNotExistsDetails = null)
        {
            evaluatedExpressions ??= new List<ExpressionEvaluationDetails>();

            return new PolicyEvaluationDetails(evaluatedExpressions?.ToList(), ifNotExistsDetails, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExpressionEvaluationDetails"/>. </summary>
        /// <param name="result"> Evaluation result. </param>
        /// <param name="expression"> Expression evaluated. </param>
        /// <param name="expressionKind"> The kind of expression that was evaluated. </param>
        /// <param name="path"> Property path if the expression is a field or an alias. </param>
        /// <param name="expressionValue"> Value of the expression. </param>
        /// <param name="targetValue"> Target value to be compared with the expression value. </param>
        /// <param name="operator"> Operator to compare the expression value and the target value. </param>
        /// <returns> A new <see cref="Models.ExpressionEvaluationDetails"/> instance for mocking. </returns>
        public static ExpressionEvaluationDetails ExpressionEvaluationDetails(string result = null, string expression = null, string expressionKind = null, string path = null, BinaryData expressionValue = null, BinaryData targetValue = null, string @operator = null)
        {
            return new ExpressionEvaluationDetails(
                result,
                expression,
                expressionKind,
                path,
                expressionValue,
                targetValue,
                @operator,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IfNotExistsEvaluationDetails"/>. </summary>
        /// <param name="resourceId"> ID of the last evaluated resource for IfNotExists effect. </param>
        /// <param name="totalResources"> Total number of resources to which the existence condition is applicable. </param>
        /// <returns> A new <see cref="Models.IfNotExistsEvaluationDetails"/> instance for mocking. </returns>
        public static IfNotExistsEvaluationDetails IfNotExistsEvaluationDetails(ResourceIdentifier resourceId = null, int? totalResources = null)
        {
            return new IfNotExistsEvaluationDetails(resourceId, totalResources, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ComponentStateDetails"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="timestamp"> Component compliance evaluation timestamp. </param>
        /// <param name="complianceState"> Component compliance state. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.ComponentStateDetails"/> instance for mocking. </returns>
        public static ComponentStateDetails ComponentStateDetails(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? timestamp = null, string complianceState = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new ComponentStateDetails(
                id,
                name,
                resourceType,
                systemData,
                timestamp,
                complianceState,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PolicySummary"/>. </summary>
        /// <param name="odataId"> OData entity ID; always set to null since summaries do not have an entity ID. </param>
        /// <param name="odataContext"> OData context string; used by OData clients to resolve type information based on metadata. </param>
        /// <param name="results"> Compliance summary for all policy assignments. </param>
        /// <param name="policyAssignments"> Policy assignments summary. </param>
        /// <returns> A new <see cref="Models.PolicySummary"/> instance for mocking. </returns>
        public static PolicySummary PolicySummary(string odataId = null, string odataContext = null, PolicySummaryResults results = null, IEnumerable<PolicyAssignmentSummary> policyAssignments = null)
        {
            policyAssignments ??= new List<PolicyAssignmentSummary>();

            return new PolicySummary(odataId, odataContext, results, policyAssignments?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PolicySummaryResults"/>. </summary>
        /// <param name="queryResultsUri"> HTTP POST URI for queryResults action on Microsoft.PolicyInsights to retrieve raw results for the compliance summary. This property will not be available by default in future API versions, but could be queried explicitly. </param>
        /// <param name="nonCompliantResources"> Number of non-compliant resources. </param>
        /// <param name="nonCompliantPolicies"> Number of non-compliant policies. </param>
        /// <param name="resourceDetails"> The resources summary at this level. </param>
        /// <param name="policyDetails"> The policy artifact summary at this level. For query scope level, it represents policy assignment summary. For policy assignment level, it represents policy definitions summary. </param>
        /// <param name="policyGroupDetails"> The policy definition group summary at this level. </param>
        /// <returns> A new <see cref="Models.PolicySummaryResults"/> instance for mocking. </returns>
        public static PolicySummaryResults PolicySummaryResults(Uri queryResultsUri = null, int? nonCompliantResources = null, int? nonCompliantPolicies = null, IEnumerable<ComplianceDetail> resourceDetails = null, IEnumerable<ComplianceDetail> policyDetails = null, IEnumerable<ComplianceDetail> policyGroupDetails = null)
        {
            resourceDetails ??= new List<ComplianceDetail>();
            policyDetails ??= new List<ComplianceDetail>();
            policyGroupDetails ??= new List<ComplianceDetail>();

            return new PolicySummaryResults(
                queryResultsUri,
                nonCompliantResources,
                nonCompliantPolicies,
                resourceDetails?.ToList(),
                policyDetails?.ToList(),
                policyGroupDetails?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ComplianceDetail"/>. </summary>
        /// <param name="complianceState"> The compliance state. </param>
        /// <param name="count"> Summarized count value for this compliance state. </param>
        /// <returns> A new <see cref="Models.ComplianceDetail"/> instance for mocking. </returns>
        public static ComplianceDetail ComplianceDetail(string complianceState = null, int? count = null)
        {
            return new ComplianceDetail(complianceState, count, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PolicyAssignmentSummary"/>. </summary>
        /// <param name="policyAssignmentId"> Policy assignment ID. </param>
        /// <param name="policySetDefinitionId"> Policy set definition ID, if the policy assignment is for a policy set. </param>
        /// <param name="results"> Compliance summary for the policy assignment. </param>
        /// <param name="policyDefinitions"> Policy definitions summary. </param>
        /// <param name="policyGroups"> Policy definition group summary. </param>
        /// <returns> A new <see cref="Models.PolicyAssignmentSummary"/> instance for mocking. </returns>
        public static PolicyAssignmentSummary PolicyAssignmentSummary(ResourceIdentifier policyAssignmentId = null, ResourceIdentifier policySetDefinitionId = null, PolicySummaryResults results = null, IEnumerable<PolicyDefinitionSummary> policyDefinitions = null, IEnumerable<PolicyGroupSummary> policyGroups = null)
        {
            policyDefinitions ??= new List<PolicyDefinitionSummary>();
            policyGroups ??= new List<PolicyGroupSummary>();

            return new PolicyAssignmentSummary(
                policyAssignmentId,
                policySetDefinitionId,
                results,
                policyDefinitions?.ToList(),
                policyGroups?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PolicyDefinitionSummary"/>. </summary>
        /// <param name="policyDefinitionId"> Policy definition ID. </param>
        /// <param name="policyDefinitionReferenceId"> Policy definition reference ID. </param>
        /// <param name="policyDefinitionGroupNames"> Policy definition group names. </param>
        /// <param name="effect"> Policy effect, i.e. policy definition action. </param>
        /// <param name="results"> Compliance summary for the policy definition. </param>
        /// <returns> A new <see cref="Models.PolicyDefinitionSummary"/> instance for mocking. </returns>
        public static PolicyDefinitionSummary PolicyDefinitionSummary(ResourceIdentifier policyDefinitionId = null, string policyDefinitionReferenceId = null, IEnumerable<string> policyDefinitionGroupNames = null, string effect = null, PolicySummaryResults results = null)
        {
            policyDefinitionGroupNames ??= new List<string>();

            return new PolicyDefinitionSummary(
                policyDefinitionId,
                policyDefinitionReferenceId,
                policyDefinitionGroupNames?.ToList(),
                effect,
                results,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PolicyGroupSummary"/>. </summary>
        /// <param name="policyGroupName"> Policy group name. </param>
        /// <param name="results"> Compliance summary for the policy definition group. </param>
        /// <returns> A new <see cref="Models.PolicyGroupSummary"/> instance for mocking. </returns>
        public static PolicyGroupSummary PolicyGroupSummary(string policyGroupName = null, PolicySummaryResults results = null)
        {
            return new PolicyGroupSummary(policyGroupName, results, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="PolicyInsights.PolicyMetadataData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="metadataId"> The policy metadata identifier. </param>
        /// <param name="category"> The category of the policy metadata. </param>
        /// <param name="title"> The title of the policy metadata. </param>
        /// <param name="owner"> The owner of the policy metadata. </param>
        /// <param name="additionalContentUri"> Url for getting additional content about the resource metadata. </param>
        /// <param name="metadata"> Additional metadata. </param>
        /// <param name="description"> The description of the policy metadata. </param>
        /// <param name="requirements"> The requirements of the policy metadata. </param>
        /// <returns> A new <see cref="PolicyInsights.PolicyMetadataData"/> instance for mocking. </returns>
        public static PolicyMetadataData PolicyMetadataData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string metadataId = null, string category = null, string title = null, string owner = null, Uri additionalContentUri = null, BinaryData metadata = null, string description = null, string requirements = null)
        {
            return new PolicyMetadataData(
                id,
                name,
                resourceType,
                systemData,
                metadataId,
                category,
                title,
                owner,
                additionalContentUri,
                metadata,
                description,
                requirements,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SlimPolicyMetadata"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="metadataId"> The policy metadata identifier. </param>
        /// <param name="category"> The category of the policy metadata. </param>
        /// <param name="title"> The title of the policy metadata. </param>
        /// <param name="owner"> The owner of the policy metadata. </param>
        /// <param name="additionalContentUri"> Url for getting additional content about the resource metadata. </param>
        /// <param name="metadata"> Additional metadata. </param>
        /// <returns> A new <see cref="Models.SlimPolicyMetadata"/> instance for mocking. </returns>
        public static SlimPolicyMetadata SlimPolicyMetadata(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string metadataId = null, string category = null, string title = null, string owner = null, Uri additionalContentUri = null, BinaryData metadata = null)
        {
            return new SlimPolicyMetadata(
                id,
                name,
                resourceType,
                systemData,
                metadataId,
                category,
                title,
                owner,
                additionalContentUri,
                metadata,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CheckPolicyRestrictionsContent"/>. </summary>
        /// <param name="resourceDetails"> The information about the resource that will be evaluated. </param>
        /// <param name="pendingFields"> The list of fields and values that should be evaluated for potential restrictions. </param>
        /// <returns> A new <see cref="Models.CheckPolicyRestrictionsContent"/> instance for mocking. </returns>
        public static CheckPolicyRestrictionsContent CheckPolicyRestrictionsContent(CheckRestrictionsResourceDetails resourceDetails = null, IEnumerable<PendingField> pendingFields = null)
        {
            pendingFields ??= new List<PendingField>();

            return new CheckPolicyRestrictionsContent(resourceDetails, pendingFields?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CheckRestrictionsResourceDetails"/>. </summary>
        /// <param name="resourceContent"> The resource content. This should include whatever properties are already known and can be a partial set of all resource properties. </param>
        /// <param name="apiVersion"> The api-version of the resource content. </param>
        /// <param name="scope"> The scope where the resource is being created. For example, if the resource is a child resource this would be the parent resource's resource ID. </param>
        /// <returns> A new <see cref="Models.CheckRestrictionsResourceDetails"/> instance for mocking. </returns>
        public static CheckRestrictionsResourceDetails CheckRestrictionsResourceDetails(BinaryData resourceContent = null, string apiVersion = null, string scope = null)
        {
            return new CheckRestrictionsResourceDetails(resourceContent, apiVersion, scope, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PendingField"/>. </summary>
        /// <param name="field"> The name of the field. This can be a top-level property like 'name' or 'type' or an Azure Policy field alias. </param>
        /// <param name="values"> The list of potential values for the field that should be evaluated against Azure Policy. </param>
        /// <returns> A new <see cref="Models.PendingField"/> instance for mocking. </returns>
        public static PendingField PendingField(string field = null, IEnumerable<string> values = null)
        {
            values ??= new List<string>();

            return new PendingField(field, values?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CheckPolicyRestrictionsResult"/>. </summary>
        /// <param name="fieldRestrictions"> The restrictions that will be placed on various fields in the resource by policy. </param>
        /// <param name="policyEvaluations"> Evaluation results for the provided partial resource content. </param>
        /// <returns> A new <see cref="Models.CheckPolicyRestrictionsResult"/> instance for mocking. </returns>
        public static CheckPolicyRestrictionsResult CheckPolicyRestrictionsResult(IEnumerable<FieldRestrictions> fieldRestrictions = null, IEnumerable<PolicyEvaluationResult> policyEvaluations = null)
        {
            fieldRestrictions ??= new List<FieldRestrictions>();
            policyEvaluations ??= new List<PolicyEvaluationResult>();

            return new CheckPolicyRestrictionsResult(fieldRestrictions?.ToList(), policyEvaluations != null ? new CheckRestrictionsResultContentEvaluationResult(policyEvaluations?.ToList(), serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FieldRestrictions"/>. </summary>
        /// <param name="field"> The name of the field. This can be a top-level property like 'name' or 'type' or an Azure Policy field alias. </param>
        /// <param name="restrictions"> The restrictions placed on that field by policy. </param>
        /// <returns> A new <see cref="Models.FieldRestrictions"/> instance for mocking. </returns>
        public static FieldRestrictions FieldRestrictions(string field = null, IEnumerable<FieldRestriction> restrictions = null)
        {
            restrictions ??= new List<FieldRestriction>();

            return new FieldRestrictions(field, restrictions?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FieldRestriction"/>. </summary>
        /// <param name="result"> The type of restriction that is imposed on the field. </param>
        /// <param name="defaultValue"> The value that policy will set for the field if the user does not provide a value. </param>
        /// <param name="values"> The values that policy either requires or denies for the field. </param>
        /// <param name="policy"> The details of the policy that is causing the field restriction. </param>
        /// <returns> A new <see cref="Models.FieldRestriction"/> instance for mocking. </returns>
        public static FieldRestriction FieldRestriction(FieldRestrictionResult? result = null, string defaultValue = null, IEnumerable<string> values = null, PolicyReference policy = null)
        {
            values ??= new List<string>();

            return new FieldRestriction(result, defaultValue, values?.ToList(), policy, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PolicyReference"/>. </summary>
        /// <param name="policyDefinitionId"> The resource identifier of the policy definition. </param>
        /// <param name="policySetDefinitionId"> The resource identifier of the policy set definition. </param>
        /// <param name="policyDefinitionReferenceId"> The reference identifier of a specific policy definition within a policy set definition. </param>
        /// <param name="policyAssignmentId"> The resource identifier of the policy assignment. </param>
        /// <returns> A new <see cref="Models.PolicyReference"/> instance for mocking. </returns>
        public static PolicyReference PolicyReference(ResourceIdentifier policyDefinitionId = null, ResourceIdentifier policySetDefinitionId = null, string policyDefinitionReferenceId = null, ResourceIdentifier policyAssignmentId = null)
        {
            return new PolicyReference(policyDefinitionId, policySetDefinitionId, policyDefinitionReferenceId, policyAssignmentId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PolicyEvaluationResult"/>. </summary>
        /// <param name="policyInfo"> The details of the policy that was evaluated. </param>
        /// <param name="evaluationResult"> The result of the policy evaluation against the resource. This will typically be 'NonCompliant' but may contain other values if errors were encountered. </param>
        /// <param name="evaluationDetails"> The detailed results of the policy expressions and values that were evaluated. </param>
        /// <returns> A new <see cref="Models.PolicyEvaluationResult"/> instance for mocking. </returns>
        public static PolicyEvaluationResult PolicyEvaluationResult(PolicyReference policyInfo = null, string evaluationResult = null, PolicyEvaluationDetails evaluationDetails = null)
        {
            return new PolicyEvaluationResult(policyInfo, evaluationResult, evaluationDetails, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="PolicyInsights.PolicyAttestationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="policyAssignmentId"> The resource ID of the policy assignment that the attestation is setting the state for. </param>
        /// <param name="policyDefinitionReferenceId"> The policy definition reference ID from a policy set definition that the attestation is setting the state for. If the policy assignment assigns a policy set definition the attestation can choose a definition within the set definition with this property or omit this and set the state for the entire set definition. </param>
        /// <param name="complianceState"> The compliance state that should be set on the resource. </param>
        /// <param name="expireOn"> The time the compliance state should expire. </param>
        /// <param name="owner"> The person responsible for setting the state of the resource. This value is typically an Azure Active Directory object ID. </param>
        /// <param name="comments"> Comments describing why this attestation was created. </param>
        /// <param name="evidence"> The evidence supporting the compliance state set in this attestation. </param>
        /// <param name="provisioningState"> The status of the attestation. </param>
        /// <param name="lastComplianceStateChangeOn"> The time the compliance state was last changed in this attestation. </param>
        /// <param name="assessOn"> The time the evidence was assessed. </param>
        /// <param name="metadata"> Additional metadata for this attestation. </param>
        /// <returns> A new <see cref="PolicyInsights.PolicyAttestationData"/> instance for mocking. </returns>
        public static PolicyAttestationData PolicyAttestationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier policyAssignmentId = null, string policyDefinitionReferenceId = null, PolicyComplianceState? complianceState = null, DateTimeOffset? expireOn = null, string owner = null, string comments = null, IEnumerable<AttestationEvidence> evidence = null, string provisioningState = null, DateTimeOffset? lastComplianceStateChangeOn = null, DateTimeOffset? assessOn = null, BinaryData metadata = null)
        {
            evidence ??= new List<AttestationEvidence>();

            return new PolicyAttestationData(
                id,
                name,
                resourceType,
                systemData,
                policyAssignmentId,
                policyDefinitionReferenceId,
                complianceState,
                expireOn,
                owner,
                comments,
                evidence?.ToList(),
                provisioningState,
                lastComplianceStateChangeOn,
                assessOn,
                metadata,
                serializedAdditionalRawData: null);
        }
    }
}
