// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.PolicyInsights.Models;

namespace Azure.ResourceManager.PolicyInsights.Samples
{
    public partial class Sample_PolicyRemediationResource
    {
        // List deployments for a remediation at individual resource scope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDeployments_ListDeploymentsForARemediationAtIndividualResourceScope()
        {
            // Generated from example definition: specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_ListDeploymentsResourceScope.json
            // this example is just showing the usage of "Remediations_ListDeploymentsAtResource" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyRemediationResource created on azure
            // for more information of creating PolicyRemediationResource, please refer to the document of PolicyRemediationResource
            string resourceId = "subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1";
            string remediationName = "myRemediation";
            ResourceIdentifier policyRemediationResourceId = PolicyRemediationResource.CreateResourceIdentifier(resourceId, remediationName);
            PolicyRemediationResource policyRemediation = client.GetPolicyRemediationResource(policyRemediationResourceId);

            // invoke the operation and iterate over the result
            await foreach (RemediationDeployment item in policyRemediation.GetDeploymentsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Cancel a remediation at individual resource scope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Cancel_CancelARemediationAtIndividualResourceScope()
        {
            // Generated from example definition: specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_CancelResourceScope.json
            // this example is just showing the usage of "Remediations_CancelAtResource" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyRemediationResource created on azure
            // for more information of creating PolicyRemediationResource, please refer to the document of PolicyRemediationResource
            string resourceId = "subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1";
            string remediationName = "myRemediation";
            ResourceIdentifier policyRemediationResourceId = PolicyRemediationResource.CreateResourceIdentifier(resourceId, remediationName);
            PolicyRemediationResource policyRemediation = client.GetPolicyRemediationResource(policyRemediationResourceId);

            // invoke the operation
            PolicyRemediationResource result = await policyRemediation.CancelAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyRemediationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create remediation at individual resource scope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateRemediationAtIndividualResourceScope()
        {
            // Generated from example definition: specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_CreateResourceScope.json
            // this example is just showing the usage of "Remediations_CreateOrUpdateAtResource" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyRemediationResource created on azure
            // for more information of creating PolicyRemediationResource, please refer to the document of PolicyRemediationResource
            string resourceId = "subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1";
            string remediationName = "storageRemediation";
            ResourceIdentifier policyRemediationResourceId = PolicyRemediationResource.CreateResourceIdentifier(resourceId, remediationName);
            PolicyRemediationResource policyRemediation = client.GetPolicyRemediationResource(policyRemediationResourceId);

            // invoke the operation
            PolicyRemediationData data = new PolicyRemediationData()
            {
                PolicyAssignmentId = new ResourceIdentifier("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourceGroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
            };
            ArmOperation<PolicyRemediationResource> lro = await policyRemediation.UpdateAsync(WaitUntil.Completed, data);
            PolicyRemediationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyRemediationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get remediation at individual resource scope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetRemediationAtIndividualResourceScope()
        {
            // Generated from example definition: specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_GetResourceScope.json
            // this example is just showing the usage of "Remediations_GetAtResource" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyRemediationResource created on azure
            // for more information of creating PolicyRemediationResource, please refer to the document of PolicyRemediationResource
            string resourceId = "subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1";
            string remediationName = "storageRemediation";
            ResourceIdentifier policyRemediationResourceId = PolicyRemediationResource.CreateResourceIdentifier(resourceId, remediationName);
            PolicyRemediationResource policyRemediation = client.GetPolicyRemediationResource(policyRemediationResourceId);

            // invoke the operation
            PolicyRemediationResource result = await policyRemediation.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyRemediationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete remediation at individual resource scope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteRemediationAtIndividualResourceScope()
        {
            // Generated from example definition: specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_DeleteResourceScope.json
            // this example is just showing the usage of "Remediations_DeleteAtResource" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyRemediationResource created on azure
            // for more information of creating PolicyRemediationResource, please refer to the document of PolicyRemediationResource
            string resourceId = "subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1";
            string remediationName = "storageRemediation";
            ResourceIdentifier policyRemediationResourceId = PolicyRemediationResource.CreateResourceIdentifier(resourceId, remediationName);
            PolicyRemediationResource policyRemediation = client.GetPolicyRemediationResource(policyRemediationResourceId);

            // invoke the operation
            ArmOperation<PolicyRemediationResource> lro = await policyRemediation.DeleteAsync(WaitUntil.Completed);
            PolicyRemediationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyRemediationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
