// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PlaywrightTesting.Models
{
    /// <summary> The PlaywrightTestingQuotaName. </summary>
    public readonly partial struct PlaywrightTestingQuotaName : IEquatable<PlaywrightTestingQuotaName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PlaywrightTestingQuotaName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PlaywrightTestingQuotaName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ScalableExecutionValue = "ScalableExecution";

        /// <summary> The quota details for scalable execution feature. When enabled, Playwright client workers can connect to cloud-hosted browsers. This can increase the number of parallel workers for a test run, significantly minimizing test completion durations. </summary>
        public static PlaywrightTestingQuotaName ScalableExecution { get; } = new PlaywrightTestingQuotaName(ScalableExecutionValue);
        /// <summary> Determines if two <see cref="PlaywrightTestingQuotaName"/> values are the same. </summary>
        public static bool operator ==(PlaywrightTestingQuotaName left, PlaywrightTestingQuotaName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PlaywrightTestingQuotaName"/> values are not the same. </summary>
        public static bool operator !=(PlaywrightTestingQuotaName left, PlaywrightTestingQuotaName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PlaywrightTestingQuotaName"/>. </summary>
        public static implicit operator PlaywrightTestingQuotaName(string value) => new PlaywrightTestingQuotaName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PlaywrightTestingQuotaName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PlaywrightTestingQuotaName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
